/*
 * Decompiled with CFR 0.152.
 */
package com.sainttx.holograms.nms.v1_14_R1;

import com.sainttx.holograms.api.HologramEntityController;
import com.sainttx.holograms.api.HologramPlugin;
import com.sainttx.holograms.api.MinecraftVersion;
import com.sainttx.holograms.api.entity.HologramEntity;
import com.sainttx.holograms.api.entity.ItemHolder;
import com.sainttx.holograms.api.entity.Nameable;
import com.sainttx.holograms.api.line.HologramLine;
import com.sainttx.holograms.nms.v1_14_R1.EntityItemHolder;
import com.sainttx.holograms.nms.v1_14_R1.EntityNameable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import net.minecraft.server.v1_14_R1.Chunk;
import net.minecraft.server.v1_14_R1.World;
import net.minecraft.server.v1_14_R1.WorldServer;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_14_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftEntity;
import org.bukkit.entity.Entity;

public class HologramEntityControllerImpl
implements HologramEntityController {
    private static final Method registerEntityMethod;
    private HologramPlugin plugin;

    public HologramEntityControllerImpl(HologramPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public MinecraftVersion getMinecraftVersion() {
        return MinecraftVersion.V1_14_R1;
    }

    @Override
    public Nameable spawnNameable(HologramLine line, Location location) {
        WorldServer nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        EntityNameable armorStand = new EntityNameable((World)nmsWorld, line);
        armorStand.setPosition(location.getX(), location.getY(), location.getZ());
        if (!this.addEntityToWorld(nmsWorld, (net.minecraft.server.v1_14_R1.Entity)armorStand)) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to spawn hologram entity in world " + location.getWorld().getName() + " at x:" + location.getX() + " y:" + location.getY() + " z:" + location.getZ());
            armorStand.remove();
            return null;
        }
        return armorStand;
    }

    @Override
    public ItemHolder spawnItemHolder(HologramLine line, Location location) {
        WorldServer nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        EntityItemHolder item = new EntityItemHolder((World)nmsWorld, line);
        item.setPosition(location.getX(), location.getY(), location.getZ());
        if (!this.addEntityToWorld(nmsWorld, (net.minecraft.server.v1_14_R1.Entity)item)) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to spawn item entity in world " + location.getWorld().getName() + " at x:" + location.getX() + " y:" + location.getY() + " z:" + location.getZ());
            item.remove();
            return null;
        }
        return item;
    }

    private boolean addEntityToWorld(WorldServer nmsWorld, net.minecraft.server.v1_14_R1.Entity nmsEntity) {
        int z;
        int x = (int)Math.floor(nmsEntity.locX / 16.0);
        if (!nmsWorld.isChunkLoaded(x, z = (int)Math.floor(nmsEntity.locZ / 16.0))) {
            nmsEntity.dead = true;
            return false;
        }
        Chunk chunk = nmsWorld.getChunkAt(x, z);
        chunk.a(nmsEntity);
        try {
            registerEntityMethod.invoke((Object)nmsWorld, nmsEntity);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public HologramEntity getHologramEntity(Entity bukkitEntity) {
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)bukkitEntity).getHandle();
        return nmsEntity instanceof HologramEntity ? (HologramEntity)nmsEntity : null;
    }

    static {
        try {
            registerEntityMethod = WorldServer.class.getDeclaredMethod("registerEntity", net.minecraft.server.v1_14_R1.Entity.class);
            registerEntityMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

