/*
 * Decompiled with CFR 0.152.
 */
package com.sainttx.holograms.nms.v1_14_R1;

import com.sainttx.holograms.api.entity.HologramEntity;
import com.sainttx.holograms.api.entity.ItemHolder;
import com.sainttx.holograms.api.line.HologramLine;
import com.sainttx.holograms.nms.v1_14_R1.CraftItemHolder;
import java.lang.reflect.Field;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.server.v1_14_R1.DamageSource;
import net.minecraft.server.v1_14_R1.Entity;
import net.minecraft.server.v1_14_R1.EntityItem;
import net.minecraft.server.v1_14_R1.EntityTypes;
import net.minecraft.server.v1_14_R1.NBTBase;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import net.minecraft.server.v1_14_R1.NBTTagList;
import net.minecraft.server.v1_14_R1.NBTTagString;
import net.minecraft.server.v1_14_R1.World;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class EntityItemHolder
extends EntityItem
implements ItemHolder {
    private static final Field vehicleField;
    private boolean lockTick;
    private HologramLine line;
    private ItemStack item;
    private CraftEntity bukkitEntity;

    public EntityItemHolder(World world, HologramLine line) {
        super(EntityTypes.ITEM, world);
        this.line = line;
        this.pickupDelay = Integer.MAX_VALUE;
        this.lockTick = true;
    }

    public void tick() {
        this.ticksLived = 0;
        if (!this.lockTick) {
            super.tick();
        }
    }

    public void b(NBTTagCompound nbttagcompound) {
    }

    public boolean c(NBTTagCompound nbttagcompound) {
        return false;
    }

    public boolean d(NBTTagCompound nbttagcompound) {
        return false;
    }

    public NBTTagCompound save(NBTTagCompound nbttagcompound) {
        return new NBTTagCompound();
    }

    public void f(NBTTagCompound nbttagcompound) {
    }

    public void a(NBTTagCompound nbttagcompound) {
    }

    public boolean isInvulnerable(DamageSource source) {
        return true;
    }

    public void die() {
    }

    public CraftEntity getBukkitEntity() {
        if (this.bukkitEntity == null) {
            this.bukkitEntity = new CraftItemHolder(this.world.getServer(), this);
        }
        return this.bukkitEntity;
    }

    @Override
    public HologramLine getHologramLine() {
        return this.line;
    }

    @Override
    public void remove() {
        this.dead = true;
        Entity vehicle = super.getVehicle();
        if (vehicle != null) {
            vehicle.dead = true;
        }
    }

    @Override
    public void setItem(ItemStack item) {
        net.minecraft.server.v1_14_R1.ItemStack nms = CraftItemStack.asNMSCopy((ItemStack)item);
        if (nms != null) {
            if (nms.getTag() == null) {
                nms.setTag(new NBTTagCompound());
            }
            NBTTagCompound display = nms.getTag().getCompound("display");
            if (!nms.getTag().hasKey("display")) {
                nms.getTag().set("display", (NBTBase)display);
            }
            NBTTagList tagList = new NBTTagList();
            tagList.add((Object)new NBTTagString(this.getRandomString()));
            display.set("Lore", (NBTBase)tagList);
        }
        this.item = item;
        this.setItemStack(nms);
    }

    private String getRandomString() {
        return Double.toString(ThreadLocalRandom.current().nextDouble());
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }

    @Override
    public HologramEntity getMount() {
        try {
            return (HologramEntity)vehicleField.get(this);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setMount(HologramEntity entity) {
        if (!(entity instanceof Entity)) {
            return;
        }
        Entity old = super.getVehicle();
        if (old != null) {
            old.passengers.remove(this);
        }
        Entity next = (Entity)entity;
        try {
            vehicleField.set(this, next);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        next.passengers.clear();
        next.passengers.add(this);
    }

    static {
        try {
            vehicleField = Entity.class.getDeclaredField("vehicle");
            vehicleField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

