/*
 * Decompiled with CFR 0.152.
 */
package com.sainttx.holograms.nms.v1_10_R1;

import com.sainttx.holograms.api.entity.HologramEntity;
import com.sainttx.holograms.api.entity.ItemHolder;
import com.sainttx.holograms.api.line.HologramLine;
import com.sainttx.holograms.nms.v1_10_R1.CraftItemHolder;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.server.v1_10_R1.DamageSource;
import net.minecraft.server.v1_10_R1.Entity;
import net.minecraft.server.v1_10_R1.EntityItem;
import net.minecraft.server.v1_10_R1.EntityPlayer;
import net.minecraft.server.v1_10_R1.NBTBase;
import net.minecraft.server.v1_10_R1.NBTTagCompound;
import net.minecraft.server.v1_10_R1.NBTTagList;
import net.minecraft.server.v1_10_R1.NBTTagString;
import net.minecraft.server.v1_10_R1.Packet;
import net.minecraft.server.v1_10_R1.PacketPlayOutMount;
import net.minecraft.server.v1_10_R1.World;
import org.bukkit.craftbukkit.v1_10_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_10_R1.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class EntityItemHolder
extends EntityItem
implements ItemHolder {
    private boolean lockTick;
    private HologramLine line;
    private Entity vehicle;
    private int mountPacketTick;
    private ItemStack item;

    public EntityItemHolder(World world, HologramLine line) {
        super(world);
        this.line = line;
        this.pickupDelay = Integer.MAX_VALUE;
        this.lockTick = true;
    }

    public void m() {
        this.ticksLived = 0;
        if (this.mountPacketTick++ > 20) {
            this.mountPacketTick = 0;
            this.mountPacket();
        }
        if (!this.lockTick) {
            super.m();
        }
    }

    private void mountPacket() {
        PacketPlayOutMount packet = new PacketPlayOutMount(this.vehicle);
        this.world.players.stream().filter(e -> e instanceof EntityPlayer).map(e -> (EntityPlayer)e).forEach(p -> {
            double distanceSquared = Math.pow(p.locX - this.locX, 2.0) + Math.pow(p.locZ - this.locZ, 2.0);
            if (distanceSquared < 1024.0 && p.playerConnection != null) {
                p.playerConnection.sendPacket((Packet)packet);
            }
        });
    }

    public void b(NBTTagCompound nbttagcompound) {
    }

    public boolean c(NBTTagCompound nbttagcompound) {
        return false;
    }

    public boolean d(NBTTagCompound nbttagcompound) {
        return false;
    }

    public NBTTagCompound e(NBTTagCompound nbttagcompound) {
        return new NBTTagCompound();
    }

    public void f(NBTTagCompound nbttagcompound) {
    }

    public void a(NBTTagCompound nbttagcompound) {
    }

    public boolean isInvulnerable(DamageSource source) {
        return true;
    }

    public void die() {
    }

    public CraftEntity getBukkitEntity() {
        if (this.bukkitEntity == null) {
            this.bukkitEntity = new CraftItemHolder(this.world.getServer(), this);
        }
        return this.bukkitEntity;
    }

    @Override
    public HologramLine getHologramLine() {
        return this.line;
    }

    @Override
    public void remove() {
        this.lockTick = false;
        this.removeMount();
        super.die();
    }

    @Override
    public void setItem(ItemStack item) {
        net.minecraft.server.v1_10_R1.ItemStack nms = CraftItemStack.asNMSCopy((ItemStack)item);
        if (nms != null) {
            if (nms.getTag() == null) {
                nms.setTag(new NBTTagCompound());
            }
            NBTTagCompound display = nms.getTag().getCompound("display");
            if (!nms.getTag().hasKey("display")) {
                nms.getTag().set("display", (NBTBase)display);
            }
            NBTTagList tagList = new NBTTagList();
            tagList.add((NBTBase)new NBTTagString(this.getRandomString()));
            display.set("Lore", (NBTBase)tagList);
        }
        this.item = item;
        this.setItemStack(nms);
    }

    private String getRandomString() {
        return Double.toString(ThreadLocalRandom.current().nextDouble());
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }

    @Override
    public HologramEntity getMount() {
        return (HologramEntity)this.vehicle;
    }

    @Override
    public void setMount(HologramEntity entity) {
        if (entity == null) {
            this.removeMount();
        } else if (entity instanceof Entity) {
            this.removeMount();
            this.vehicle = (Entity)entity;
            super.a(this.vehicle, true);
            this.vehicle.passengers.add(this);
        }
    }

    private void removeMount() {
        if (this.vehicle != null) {
            this.stopRiding();
            this.vehicle.passengers.remove(this);
            this.vehicle.die();
            this.vehicle = null;
        }
    }
}

