/*
 * Decompiled with CFR 0.152.
 */
package com.sainttx.holograms.commands;

import com.sainttx.holograms.api.HologramPlugin;
import com.sainttx.holograms.commands.CommandAddLine;
import com.sainttx.holograms.commands.CommandCreate;
import com.sainttx.holograms.commands.CommandDelete;
import com.sainttx.holograms.commands.CommandImport;
import com.sainttx.holograms.commands.CommandInfo;
import com.sainttx.holograms.commands.CommandInsertLine;
import com.sainttx.holograms.commands.CommandList;
import com.sainttx.holograms.commands.CommandMoveHere;
import com.sainttx.holograms.commands.CommandNear;
import com.sainttx.holograms.commands.CommandRemoveLine;
import com.sainttx.holograms.commands.CommandSetLine;
import com.sainttx.holograms.util.TextUtil;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class HologramCommands
implements CommandExecutor {
    private HologramPlugin plugin;
    private Map<String, CommandExecutor> commands = new HashMap<String, CommandExecutor>();

    public HologramCommands(HologramPlugin plugin) {
        this.plugin = plugin;
        this.commands.put("addline", new CommandAddLine(plugin));
        this.commands.put("create", new CommandCreate(plugin));
        this.commands.put("delete", new CommandDelete(plugin));
        this.commands.put("import", new CommandImport(plugin));
        this.commands.put("info", new CommandInfo(plugin));
        this.commands.put("insertline", new CommandInsertLine(plugin));
        this.commands.put("list", new CommandList(plugin));
        this.commands.put("movehere", new CommandMoveHere(plugin));
        this.commands.put("near", new CommandNear(plugin));
        this.commands.put("removeline", new CommandRemoveLine(plugin));
        this.commands.put("setline", new CommandSetLine(plugin));
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.sendMenu(sender);
        } else {
            String subCommand = args[0].toLowerCase();
            if (!sender.hasPermission("holograms." + subCommand)) {
                sender.sendMessage(ChatColor.RED + command.getPermissionMessage());
            } else {
                CommandExecutor subCommandExec = this.commands.get(subCommand);
                if (subCommandExec == null) {
                    this.sendMenu(sender);
                } else {
                    return subCommandExec.onCommand(sender, command, label, args);
                }
            }
        }
        return false;
    }

    private void sendMenu(CommandSender sender) {
        sender.sendMessage(TextUtil.color("&7&m----------&7[ &eHolograms Help &7]&m----------"));
        sender.sendMessage(TextUtil.color("&e/holograms addline &f<name> <text>"));
        sender.sendMessage(TextUtil.color("&e/holograms create &f<name> <text>"));
        sender.sendMessage(TextUtil.color("&e/holograms delete &f<name>"));
        sender.sendMessage(TextUtil.color("&e/holograms import &f<plugin>"));
        sender.sendMessage(TextUtil.color("&e/holograms info &f<name>"));
        sender.sendMessage(TextUtil.color("&e/holograms insertline &f<name> <index> <text>"));
        sender.sendMessage(TextUtil.color("&e/holograms list"));
        sender.sendMessage(TextUtil.color("&e/holograms movehere &f<name>"));
        sender.sendMessage(TextUtil.color("&e/holograms near &f<radius>"));
        sender.sendMessage(TextUtil.color("&e/holograms removeline &f<name> <index>"));
        sender.sendMessage(TextUtil.color("&e/holograms setline &f<name> <index> <text>"));
        sender.sendMessage(TextUtil.color("&7&oHolograms v" + this.plugin.getDescription().getVersion() + " by SainttX"));
    }
}

