/*
 * Decompiled with CFR 0.152.
 */
package com.sainttx.holograms.commands;

import com.sainttx.holograms.Configuration;
import com.sainttx.holograms.api.Hologram;
import com.sainttx.holograms.api.HologramPlugin;
import com.sainttx.holograms.util.TextUtil;
import java.io.File;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;

public class CommandImport
implements CommandExecutor {
    private HologramPlugin plugin;

    public CommandImport(HologramPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(ChatColor.RED + "Usage: /hologram import <plugin>");
        } else {
            String toImport = args[1];
            if (!toImport.equalsIgnoreCase("holographicdisplays")) {
                sender.sendMessage(ChatColor.RED + "Valid plugins to import: HolographicDisplays");
            } else {
                File holoDatabase = new File(this.plugin.getDataFolder().getParentFile(), "HolographicDisplays" + File.separator + "database.yml");
                if (!holoDatabase.exists()) {
                    sender.sendMessage(ChatColor.RED + "File \"../plugins/HolographicDisplays/database.yml\" couldn't be found");
                } else {
                    sender.sendMessage(TextUtil.color("&7&oImporting holograms from HolographicDisplays..."));
                    YamlConfiguration config = Configuration.loadConfiguration((File)holoDatabase);
                    Random random = new Random();
                    for (String holoName : config.getKeys(false)) {
                        try {
                            Location location = this.convertHologramLocation(config.getString(holoName + ".location"));
                            if (location == null) {
                                sender.sendMessage(TextUtil.color("&c&oHologram \"" + holoName + "\" has no location and was skipped"));
                                continue;
                            }
                            List lines = config.getStringList(holoName + ".lines");
                            if (lines == null || lines.isEmpty()) {
                                sender.sendMessage(TextUtil.color("&c&oHologram \"" + holoName + "\" has no lines and was skipped"));
                                continue;
                            }
                            if (this.plugin.getHologramManager().getHologram(holoName) != null) {
                                int randomInt = random.nextInt(1000);
                                sender.sendMessage(TextUtil.color("&e&oHologram \"" + holoName + "\" was renamed to \"" + holoName + randomInt + "\" (already existed)"));
                                holoName = holoName + randomInt;
                            }
                            Hologram hologram = new Hologram(holoName, location, true);
                            for (String text : lines) {
                                try {
                                    hologram.addLine(this.plugin.parseLine(hologram, text));
                                }
                                catch (Exception ex) {
                                    this.plugin.getLogger().log(Level.SEVERE, "Attempted to parse invalid hologram line", ex);
                                }
                            }
                            this.plugin.getHologramManager().addActiveHologram(hologram);
                            this.plugin.getHologramManager().saveHologram(hologram);
                            sender.sendMessage(TextUtil.color("&a&oSuccessfully converted HolographicDisplays hologram \"" + holoName + "\"."));
                        }
                        catch (Exception ex) {
                            sender.sendMessage(TextUtil.color("&c&oFailed to convert hologram \"" + holoName + "\", check your CONSOLE for information."));
                            this.plugin.getLogger().log(Level.SEVERE, "Failed to convert hologram \"" + holoName + "\"", ex);
                        }
                    }
                }
            }
        }
        return true;
    }

    private Location convertHologramLocation(String location) {
        if (location != null) {
            String[] pieces = location.split(",");
            World world = Bukkit.getWorld((String)pieces[0]);
            double x = Double.parseDouble(pieces[1]);
            double y = Double.parseDouble(pieces[2]);
            double z = Double.parseDouble(pieces[3]);
            return new Location(world, x, y, z);
        }
        return null;
    }
}

