/*
 * Decompiled with CFR 0.152.
 */
package com.sainttx.holograms.api.line;

import com.sainttx.holograms.api.Hologram;
import com.sainttx.holograms.api.HologramPlugin;
import com.sainttx.holograms.api.entity.Nameable;
import com.sainttx.holograms.api.line.AbstractLine;
import com.sainttx.holograms.api.line.TextualHologramLine;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.plugin.java.JavaPlugin;

public class TextLine
extends AbstractLine
implements TextualHologramLine {
    private String text;
    private Nameable nameable;

    public TextLine(Hologram parent, String text) {
        this(parent, text, text);
    }

    TextLine(Hologram parent, String raw, String text) {
        super(parent, raw);
        this.text = ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    @Override
    public void setLocation(Location location) {
        super.setLocation(location);
        if (!this.isHidden()) {
            this.nameable.getBukkitEntity().teleport(this.getLocation());
        }
    }

    @Override
    public void hide() {
        if (this.isHidden()) {
            throw new IllegalStateException("This hologram line is already hidden");
        }
        this.nameable.remove();
        this.nameable = null;
    }

    @Override
    public boolean show() {
        if (!this.isHidden()) {
            throw new IllegalStateException("This hologram line is already being displayed");
        }
        HologramPlugin plugin = (HologramPlugin)JavaPlugin.getPlugin(HologramPlugin.class);
        this.nameable = plugin.getEntityController().spawnNameable(this, this.getLocation());
        if (this.nameable == null) {
            return false;
        }
        this.nameable.setName(this.text);
        return true;
    }

    @Override
    public boolean isHidden() {
        return this.nameable == null;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
        this.setRaw(text);
        this.nameable.setName(text);
    }

    @Override
    public double getHeight() {
        return 0.23;
    }
}

