/*
 * Decompiled with CFR 0.152.
 */
package com.sainttx.holograms.api.line;

import com.sainttx.holograms.api.Hologram;
import com.sainttx.holograms.api.HologramPlugin;
import com.sainttx.holograms.api.entity.HologramEntity;
import com.sainttx.holograms.api.entity.ItemHolder;
import com.sainttx.holograms.api.line.AbstractLine;
import com.sainttx.holograms.api.line.ItemCarryingHologramLine;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class ItemLine
extends AbstractLine
implements ItemCarryingHologramLine {
    private static final Pattern linePattern = Pattern.compile("((item|icon|itemstack):)(.+)");
    private ItemStack item;
    private ItemHolder entity;

    public ItemLine(Hologram parent, String raw) {
        this(parent, raw, ItemLine.parseItem(raw));
    }

    public ItemLine(Hologram parent, ItemStack item) {
        this(parent, "item:" + ItemLine.itemstackToRaw(item), item);
    }

    ItemLine(Hologram parent, String raw, ItemStack item) {
        super(parent, raw);
        Validate.notNull((Object)item, (String)"Item cannot be null");
        this.item = item;
    }

    private static ItemStack parseItem(String text) {
        int amount;
        Material material;
        Matcher matcher = linePattern.matcher(text);
        if (matcher.find()) {
            text = matcher.group(3);
        }
        String[] split = text.split(" ");
        int durability = -1;
        String data = split[0];
        if (data.contains(":")) {
            String[] datasplit = data.split(":");
            data = datasplit[0];
            durability = Short.parseShort(datasplit[1]);
        }
        Material material2 = material = data.matches("[0-9]+") ? Material.getMaterial((int)Integer.parseInt(data)) : Material.getMaterial((String)data.toUpperCase());
        if (material == null) {
            throw new IllegalArgumentException("Invalid material " + data);
        }
        try {
            amount = split.length == 1 ? 1 : Integer.parseInt(split[1]);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid amount \"" + split[1] + "\"", ex);
        }
        ItemStack item = new ItemStack(material, amount, (short)Math.max(0, durability));
        ItemMeta meta = item.getItemMeta();
        if (split.length < 3) {
            return item;
        }
        block12: for (int i = 2; i < split.length; ++i) {
            String[] information = split[i].split(":");
            switch (information[0].toLowerCase()) {
                case "name": {
                    String name = information[1].replace(' ', ' ');
                    meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
                    continue block12;
                }
                case "lore": {
                    String[] loreLines;
                    List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
                    for (String line : loreLines = information[1].split("\\|")) {
                        line = line.replace('_', ' ');
                        lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                    }
                    meta.setLore(lore);
                    continue block12;
                }
                case "data": {
                    short dataValue = Short.parseShort(information[1]);
                    item.setDurability(dataValue);
                }
                default: {
                    Enchantment ench = Enchantment.getByName((String)information[0].toUpperCase());
                    int level = Integer.parseInt(information[1]);
                    if (ench != null) {
                        meta.addEnchant(ench, level, true);
                        continue block12;
                    }
                    throw new IllegalArgumentException("Invalid enchantment " + information[0]);
                }
            }
        }
        item.setItemMeta(meta);
        return item;
    }

    static String itemstackToRaw(ItemStack itemstack) {
        StringBuilder sb = new StringBuilder();
        sb.append(itemstack.getType().toString());
        sb.append(':').append(itemstack.getDurability());
        sb.append(' ').append(itemstack.getAmount());
        if (itemstack.hasItemMeta()) {
            ItemMeta meta = itemstack.getItemMeta();
            if (meta.hasDisplayName()) {
                sb.append(' ').append("name:").append(meta.getDisplayName().replace(' ', '_'));
            }
            if (meta.hasLore()) {
                sb.append(' ').append("lore:");
                Iterator iterator = meta.getLore().iterator();
                while (iterator.hasNext()) {
                    sb.append(((String)iterator.next()).replace(' ', '_'));
                    if (!iterator.hasNext()) continue;
                    sb.append('|');
                }
            }
            meta.getEnchants().forEach((ench, level) -> sb.append(' ').append(ench.getName()).append(':').append(level));
        }
        return sb.toString();
    }

    @Override
    public void setLocation(Location location) {
        super.setLocation(location);
        if (!this.isHidden()) {
            this.entity.setMount(null);
            this.entity.getBukkitEntity().teleport(this.getLocation());
            this.entity.setMount(this.createMount());
        }
    }

    @Override
    public void hide() {
        if (this.isHidden()) {
            throw new IllegalStateException("This hologram line is already hidden");
        }
        this.entity.setMount(null);
        this.entity.remove();
        this.entity = null;
    }

    @Override
    public boolean show() {
        if (!this.isHidden()) {
            throw new IllegalStateException("This hologram line is already being displayed");
        }
        HologramPlugin plugin = (HologramPlugin)JavaPlugin.getPlugin(HologramPlugin.class);
        this.entity = plugin.getEntityController().spawnItemHolder(this, this.getLocation());
        if (this.entity == null) {
            return false;
        }
        this.entity.setItem(this.item);
        this.entity.setMount(this.createMount());
        return true;
    }

    private HologramEntity createMount() {
        HologramPlugin plugin = (HologramPlugin)JavaPlugin.getPlugin(HologramPlugin.class);
        return plugin.getEntityController().spawnNameable(this, this.getLocation());
    }

    @Override
    public boolean isHidden() {
        return this.entity == null;
    }

    @Override
    public ItemStack getItem() {
        return this.item.clone();
    }

    @Override
    public void setItem(ItemStack item) {
        this.item = item.clone();
        this.entity.setItem(this.item);
    }

    @Override
    public double getHeight() {
        HologramPlugin plugin = (HologramPlugin)JavaPlugin.getPlugin(HologramPlugin.class);
        switch (plugin.getEntityController().getMinecraftVersion()) {
            case V1_8_R1: {
                return 1.6;
            }
        }
        return 0.8;
    }
}

