/*
 * Decompiled with CFR 0.152.
 */
package com.sainttx.holograms.api.line;

import com.sainttx.holograms.api.Hologram;
import com.sainttx.holograms.api.animation.Animation;
import com.sainttx.holograms.api.line.TextLine;
import com.sainttx.holograms.api.line.UpdatingHologramLine;
import java.util.Iterator;

public class AnimatedTextLine
extends TextLine
implements UpdatingHologramLine {
    private Animation<String> animation;
    private long delay;
    private long lastUpdate;

    public AnimatedTextLine(Hologram parent, Animation<String> animation) {
        this(parent, animation, 5000L);
    }

    public AnimatedTextLine(Hologram parent, Animation<String> animation, long delay) {
        super(parent, "animated_text(" + delay + "):" + AnimatedTextLine.animationToRaw(animation), animation.firstSlide());
        this.animation = animation;
        this.delay = delay;
    }

    private static String animationToRaw(Animation<String> animation) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = animation.getSlides().iterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append("||");
        }
        return sb.toString();
    }

    @Override
    public void update() {
        this.setText(this.animation.nextSlide());
        this.lastUpdate = System.currentTimeMillis();
    }

    @Override
    public long getDelay() {
        return this.delay;
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdate;
    }
}

