/*
 * Decompiled with CFR 0.152.
 */
package com.sainttx.holograms.api.line;

import com.sainttx.holograms.api.Hologram;
import com.sainttx.holograms.api.animation.Animation;
import com.sainttx.holograms.api.line.ItemLine;
import com.sainttx.holograms.api.line.UpdatingHologramLine;
import java.util.Iterator;
import org.bukkit.inventory.ItemStack;

public class AnimatedItemLine
extends ItemLine
implements UpdatingHologramLine {
    private Animation<ItemStack> animation;
    private long delay;
    private long lastUpdate;

    public AnimatedItemLine(Hologram parent, Animation<ItemStack> animation) {
        this(parent, animation, 5000L);
    }

    public AnimatedItemLine(Hologram parent, Animation<ItemStack> animation, long delay) {
        super(parent, "animated_item(" + delay + "):" + AnimatedItemLine.animationToRaw(animation), animation.firstSlide());
        this.animation = animation;
        this.delay = delay;
    }

    private static String animationToRaw(Animation<ItemStack> animation) {
        StringBuilder sb = new StringBuilder();
        Iterator<ItemStack> iterator = animation.getSlides().iterator();
        while (iterator.hasNext()) {
            sb.append(AnimatedItemLine.itemstackToRaw(iterator.next()));
            if (!iterator.hasNext()) continue;
            sb.append("||");
        }
        return sb.toString();
    }

    @Override
    public void update() {
        this.setItem(this.animation.nextSlide());
        this.lastUpdate = System.currentTimeMillis();
    }

    @Override
    public long getDelay() {
        return this.delay;
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdate;
    }
}

