/*
 * Decompiled with CFR 0.152.
 */
package com.sainttx.holograms.api.animation;

import com.sainttx.holograms.api.animation.Animation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.Validate;

public class TextAnimation
implements Animation<String> {
    private final List<String> slides;
    private int slide = 0;

    public TextAnimation() {
        this.slides = new ArrayList<String>();
    }

    public TextAnimation(String ... stacks) {
        Validate.notNull((Object)stacks, (String)"Cannot provide null stacks");
        this.slides = Arrays.asList(stacks);
    }

    public TextAnimation(List<String> stacks) {
        Validate.notNull(stacks, (String)"Cannot provide null stacks");
        this.slides = stacks;
    }

    @Override
    public String firstSlide() {
        return this.slides.get(0);
    }

    @Override
    public String nextSlide() {
        if (this.slides.isEmpty()) {
            throw new IllegalStateException("There are no slides to display");
        }
        if (this.slide >= this.slides.size()) {
            this.slide = 0;
        }
        return this.slides.get(this.slide++);
    }

    @Override
    public Collection<String> getSlides() {
        return this.slides;
    }

    @Override
    public boolean addSlide(String slide) {
        return this.slides.add(slide);
    }

    @Override
    public boolean removeSlide(String slide) {
        if (this.slides.remove(slide)) {
            this.slide = Math.min(this.slide, this.slides.size());
            return true;
        }
        return false;
    }
}

