/*
 * Decompiled with CFR 0.152.
 */
package com.sainttx.holograms.api.animation;

import com.sainttx.holograms.api.animation.Animation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.inventory.ItemStack;

public class ItemAnimation
implements Animation<ItemStack> {
    private final List<ItemStack> slides;
    private int slide = 0;

    public ItemAnimation() {
        this.slides = new ArrayList<ItemStack>();
    }

    public ItemAnimation(ItemStack ... stacks) {
        Validate.notNull((Object)stacks, (String)"Cannot provide null stacks");
        this.slides = Arrays.asList(stacks);
    }

    public ItemAnimation(List<ItemStack> stacks) {
        Validate.notNull(stacks, (String)"Cannot provide null stacks");
        this.slides = stacks;
    }

    @Override
    public ItemStack firstSlide() {
        return this.slides.get(0);
    }

    @Override
    public ItemStack nextSlide() {
        if (this.slides.isEmpty()) {
            throw new IllegalStateException("There are no slides to display");
        }
        if (this.slide >= this.slides.size()) {
            this.slide = 0;
        }
        return this.slides.get(this.slide++);
    }

    @Override
    public Collection<ItemStack> getSlides() {
        return this.slides;
    }

    @Override
    public boolean addSlide(ItemStack slide) {
        return this.slides.add(slide);
    }

    @Override
    public boolean removeSlide(ItemStack slide) {
        if (this.slides.remove(slide)) {
            this.slide = Math.min(this.slide, this.slides.size());
            return true;
        }
        return false;
    }
}

