/*
 * Decompiled with CFR 0.152.
 */
package com.sainttx.holograms.api;

import com.sainttx.holograms.api.Hologram;
import com.sainttx.holograms.api.HologramEntityController;
import com.sainttx.holograms.api.HologramManager;
import com.sainttx.holograms.api.line.HologramLine;
import com.sainttx.holograms.api.line.TextLine;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class HologramPlugin
extends JavaPlugin {
    private Set<HologramLine.Parser> parsers = new HashSet<HologramLine.Parser>();

    public HologramLine parseLine(Hologram hologram, String text) {
        Optional<HologramLine.Parser> parser = this.parsers.stream().filter(p -> p.canParse(text)).findFirst();
        return parser.isPresent() ? parser.get().parse(hologram, text) : new TextLine(hologram, text);
    }

    public boolean addLineParser(HologramLine.Parser parser) {
        return this.parsers.add(parser);
    }

    public abstract HologramManager getHologramManager();

    public abstract HologramEntityController getEntityController();
}

