/*
 * Decompiled with CFR 0.152.
 */
package com.sainttx.holograms.api;

import com.sainttx.holograms.api.HologramPlugin;
import com.sainttx.holograms.api.line.HologramLine;
import com.sainttx.holograms.api.line.UpdatingHologramLine;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.plugin.java.JavaPlugin;

public class Hologram {
    private final HologramPlugin plugin;
    private final String id;
    private Location location;
    private boolean persist;
    private boolean dirty;
    private List<HologramLine> lines = new ArrayList<HologramLine>();

    @ConstructorProperties(value={"id", "location"})
    public Hologram(String id, Location location) {
        this(id, location, false);
    }

    @ConstructorProperties(value={"id", "location", "persist"})
    public Hologram(String id, Location location, boolean persist) {
        Validate.notNull((Object)id, (String)"Hologram id cannot be null");
        Validate.notNull((Object)location, (String)"Hologram location cannot be null");
        this.plugin = (HologramPlugin)JavaPlugin.getPlugin(HologramPlugin.class);
        this.id = id;
        this.location = location;
        this.persist = persist;
    }

    private void saveIfPersistent() {
        if (this.isPersistent()) {
            this.plugin.getHologramManager().saveHologram(this);
            this.setDirty(false);
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean isPersistent() {
        return this.persist;
    }

    public void setPersistent(boolean persist) {
        this.persist = persist;
        this.setDirty(true);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public Location getLocation() {
        return this.location.clone();
    }

    public List<HologramLine> getLines() {
        return this.lines;
    }

    public void addLine(HologramLine line) {
        this.addLine(line, this.lines.size());
    }

    public void addLine(HologramLine line, int index) {
        this.lines.add(index, line);
        line.show();
        this.reorganize();
        if (line instanceof UpdatingHologramLine) {
            this.plugin.getHologramManager().trackLine((UpdatingHologramLine)line);
        }
        this.setDirty(true);
        this.saveIfPersistent();
    }

    public void removeLine(HologramLine line) {
        Validate.isTrue((boolean)this.lines.contains(line), (String)"Line is not a part of this hologram");
        this.lines.remove(line);
        if (!line.isHidden()) {
            line.hide();
        }
        if (line instanceof UpdatingHologramLine) {
            this.plugin.getHologramManager().untrackLine((UpdatingHologramLine)line);
        }
        this.reorganize();
        this.setDirty(true);
        this.saveIfPersistent();
    }

    public HologramLine getLine(int index) {
        if (index < 0 || index >= this.lines.size()) {
            return null;
        }
        return this.lines.get(index);
    }

    private void reorganize() {
        if (this.lines.isEmpty()) {
            return;
        }
        Location location = this.getLocation();
        double y = location.getY();
        HologramLine first = this.getLine(0);
        first.setLocation(location);
        y -= first.getHeight() / 2.0;
        y -= 0.02;
        for (int i = 1; i < this.lines.size(); ++i) {
            HologramLine line = this.getLine(i);
            if (line == null || line.isHidden()) continue;
            double height = line.getHeight();
            double middle = height / 2.0;
            location.setY(y -= middle);
            y -= middle;
            y -= 0.02;
            line.setLocation(location);
        }
    }

    public void despawn() {
        this.getLines().stream().filter(line -> !line.isHidden()).forEach(HologramLine::hide);
    }

    public void spawn() {
        this.getLines().stream().filter(HologramLine::isHidden).forEach(HologramLine::show);
    }

    public void teleport(Location location) {
        if (!this.location.equals((Object)location)) {
            this.location = location.clone();
            this.reorganize();
            this.setDirty(true);
            this.saveIfPersistent();
        }
    }
}

