/*
 * Decompiled with CFR 0.152.
 */
package com.sainttx.holograms;

import com.sainttx.holograms.Configuration;
import com.sainttx.holograms.HologramPlugin;
import com.sainttx.holograms.api.Hologram;
import com.sainttx.holograms.api.HologramManager;
import com.sainttx.holograms.api.exception.HologramEntitySpawnException;
import com.sainttx.holograms.api.line.HologramLine;
import com.sainttx.holograms.api.line.UpdatingHologramLine;
import com.sainttx.holograms.util.LocationUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Location;

public class ManagerImpl
implements HologramManager {
    private HologramPlugin plugin;
    private Configuration persistingHolograms;
    private Map<String, Hologram> activeHolograms = new TreeMap<String, Hologram>(String.CASE_INSENSITIVE_ORDER);
    private Set<UpdatingHologramLine> trackedUpdatingLines = new HashSet<UpdatingHologramLine>();

    ManagerImpl(HologramPlugin plugin) {
        this.plugin = plugin;
        this.persistingHolograms = new Configuration(plugin, "holograms.yml");
    }

    void load() {
        if (this.persistingHolograms == null) {
            this.persistingHolograms = new Configuration(this.plugin, "holograms.yml");
        }
        if (this.persistingHolograms.isConfigurationSection("holograms")) {
            block2: for (String hologramName : this.persistingHolograms.getConfigurationSection("holograms").getKeys(false)) {
                List uncoloredLines = this.persistingHolograms.getStringList("holograms." + hologramName + ".lines");
                Location location = LocationUtil.stringAsLocation(this.persistingHolograms.getString("holograms." + hologramName + ".location"));
                if (location == null) {
                    this.plugin.getLogger().warning("Hologram \"" + hologramName + "\" has an invalid location");
                    continue;
                }
                Hologram hologram = new Hologram(hologramName, location, true);
                for (String string : uncoloredLines) {
                    HologramLine line = this.plugin.parseLine(hologram, string);
                    try {
                        hologram.addLine(line);
                    }
                    catch (HologramEntitySpawnException e) {
                        this.plugin.getLogger().log(Level.WARNING, "Failed to spawn Hologram \"" + hologramName + "\"", e);
                        continue block2;
                    }
                }
                this.addActiveHologram(hologram);
                this.plugin.getLogger().info("Loaded hologram with \"" + hologram.getId() + "\" with " + hologram.getLines().size() + " lines");
            }
        } else {
            this.plugin.getLogger().warning("holograms.yml file had no 'holograms' section defined, no holograms loaded");
        }
    }

    @Override
    public void saveHologram(Hologram hologram) {
        String hologramName = hologram.getId();
        List<HologramLine> holoLines = hologram.getLines();
        List uncoloredLines = holoLines.stream().map(HologramLine::getRaw).collect(Collectors.toList());
        hologram.setDirty(false);
        this.persistingHolograms.set("holograms." + hologramName + ".location", LocationUtil.locationAsString(hologram.getLocation()));
        this.persistingHolograms.set("holograms." + hologramName + ".lines", uncoloredLines);
        this.persistingHolograms.saveConfiguration();
    }

    @Override
    public void deleteHologram(Hologram hologram) {
        hologram.despawn();
        this.removeActiveHologram(hologram);
        this.persistingHolograms.set("holograms." + hologram.getId(), null);
        this.persistingHolograms.saveConfiguration();
    }

    @Override
    public Hologram getHologram(String name) {
        return this.activeHolograms.get(name);
    }

    @Override
    public Map<String, Hologram> getActiveHolograms() {
        return this.activeHolograms;
    }

    @Override
    public void addActiveHologram(Hologram hologram) {
        this.activeHolograms.put(hologram.getId(), hologram);
    }

    @Override
    public void removeActiveHologram(Hologram hologram) {
        this.activeHolograms.remove(hologram.getId());
    }

    @Override
    public void trackLine(UpdatingHologramLine line) {
        this.trackedUpdatingLines.add(line);
    }

    @Override
    public boolean untrackLine(UpdatingHologramLine line) {
        return this.trackedUpdatingLines.remove(line);
    }

    @Override
    public Collection<? extends UpdatingHologramLine> getTrackedLines() {
        return this.trackedUpdatingLines;
    }

    @Override
    public void clear() {
        this.getActiveHolograms().values().forEach(Hologram::despawn);
        this.getActiveHolograms().clear();
    }
}

