/*
 * Decompiled with CFR 0.152.
 */
package com.sainttx.holograms;

import com.sainttx.holograms.HologramListener;
import com.sainttx.holograms.ManagerImpl;
import com.sainttx.holograms.api.HologramEntityController;
import com.sainttx.holograms.api.HologramManager;
import com.sainttx.holograms.commands.HologramCommands;
import com.sainttx.holograms.parser.AnimatedItemLineParser;
import com.sainttx.holograms.parser.AnimatedTextLineParser;
import com.sainttx.holograms.parser.ItemLineParser;
import com.sainttx.holograms.tasks.HologramSaveTask;
import com.sainttx.holograms.tasks.HologramUpdateTask;
import com.sainttx.holograms.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class HologramPlugin
extends com.sainttx.holograms.api.HologramPlugin {
    public static final String NMS_PACKAGE_PATH = "com.sainttx.holograms.nms." + ReflectionUtil.getVersion();
    private HologramManager manager;
    private HologramEntityController controller;
    private Runnable saveTask = new HologramSaveTask(this);
    private Runnable updateTask = new HologramUpdateTask(this);

    public void onEnable() {
        this.manager = new ManagerImpl(this);
        this.addLineParser(new ItemLineParser());
        this.addLineParser(new AnimatedItemLineParser());
        this.addLineParser(new AnimatedTextLineParser());
        if (this.setupController()) {
            this.getServer().getPluginManager().registerEvents((Listener)new HologramListener(this), (Plugin)this);
            this.getCommand("holograms").setExecutor((CommandExecutor)new HologramCommands(this));
            this.getServer().getScheduler().runTaskLater((Plugin)this, () -> ((ManagerImpl)this.manager).load(), 1L);
            this.getServer().getScheduler().runTaskTimer((Plugin)this, this.updateTask, 2L, 2L);
        }
    }

    public void onDisable() {
        this.saveTask.run();
        this.manager.clear();
        this.manager = null;
        this.controller = null;
    }

    private boolean setupController() {
        try {
            Class<?> nmsControllerClazz = Class.forName(NMS_PACKAGE_PATH + "HologramEntityControllerImpl");
            Constructor<?> constructor = nmsControllerClazz.getConstructor(com.sainttx.holograms.api.HologramPlugin.class);
            this.controller = (HologramEntityController)constructor.newInstance(new Object[]{this});
            this.getLogger().info("HologramEntityController set to: " + this.controller.getClass().getCanonicalName());
        }
        catch (Exception ex) {
            this.getLogger().severe("The plugin couldn't create the NMS controller instance and has been disabled. This is likelydue to no supported Hologram implementation for your CraftBukkit/Spigot version.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return false;
        }
        return true;
    }

    @Override
    public HologramManager getHologramManager() {
        return this.manager;
    }

    @Override
    public HologramEntityController getEntityController() {
        return this.controller;
    }
}

