/*
 * Decompiled with CFR 0.152.
 */
package com.sainttx.holograms;

import java.io.File;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Configuration
extends YamlConfiguration {
    protected String file;
    protected JavaPlugin plugin;

    public Configuration(JavaPlugin plugin, String file) {
        this.plugin = plugin;
        this.file = file;
        this.createFile();
        this.loadConfiguration();
    }

    private void createFile() {
        File file = new File(this.plugin.getDataFolder(), this.file);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            if (!file.exists()) {
                if (this.plugin.getResource(this.file) != null) {
                    this.plugin.saveResource(this.file, false);
                } else {
                    file.createNewFile();
                }
            }
            super.load(file);
        }
        catch (Exception ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Configuration " + this.file + " could not be loaded!");
            ex.printStackTrace();
        }
    }

    public void deleteFile() {
        File file = new File(this.plugin.getDataFolder(), this.file);
        file.delete();
    }

    public void loadConfiguration() {
        try {
            File file = new File(this.plugin.getDataFolder(), this.file);
            if (!file.exists()) {
                this.createFile();
            } else {
                super.load(file);
            }
        }
        catch (Exception ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Configuration " + this.file + " could not be loaded!");
            ex.printStackTrace();
        }
    }

    public void saveConfiguration() {
        File file = new File(this.plugin.getDataFolder(), this.file);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            super.save(file);
        }
        catch (Exception ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Configuration \"" + this.file + "\" could not be saved!");
            ex.printStackTrace();
        }
    }
}

