/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.type;

import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import java.util.ArrayList;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.api.util.NumericStatFormula;
import net.Indyuce.mmoitems.stat.data.DoubleData;
import net.Indyuce.mmoitems.stat.data.RequiredLevelData;
import net.Indyuce.mmoitems.stat.data.random.RandomRequiredLevelData;
import net.Indyuce.mmoitems.stat.type.DoubleStat;
import net.Indyuce.mmoitems.stat.type.GemStoneStat;
import net.Indyuce.mmoitems.stat.type.ItemRestriction;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RequiredLevelStat
extends DoubleStat
implements ItemRestriction,
GemStoneStat {
    @Deprecated
    public RequiredLevelStat(boolean ignored, String idKey, Material mat, String nameKey, String[] lore) {
        super(idKey, mat, "Required " + nameKey, lore, new String[]{"!block", "all"}, new Material[0]);
    }

    public RequiredLevelStat(String idKey, Material mat, String nameKey, String[] lore) {
        super("REQUIRED_" + idKey, mat, "Required " + nameKey, lore, new String[]{"!block", "all"}, new Material[0]);
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull DoubleData data) {
        int requirement = (int)data.getValue();
        String format = this.getGeneralStatFormat().replace("{value}", String.valueOf(requirement));
        item.getLore().insert(this.getPath(), format);
        item.addItemTag(new ItemTag(this.getNBTPath(), (Object)requirement));
    }

    @Override
    public void whenPreviewed(@NotNull ItemStackBuilder item, @NotNull DoubleData currentData, @NotNull NumericStatFormula templateData) throws IllegalArgumentException {
        double techMinimum = templateData.calculate(0.0, NumericStatFormula.FormulaInputType.LOWER_BOUND);
        double techMaximum = templateData.calculate(0.0, NumericStatFormula.FormulaInputType.UPPER_BOUND);
        if (techMaximum < 0.0 && !this.handleNegativeStats()) {
            return;
        }
        if (techMinimum < 0.0 && !this.handleNegativeStats()) {
            techMinimum = 0.0;
        }
        if (techMinimum < templateData.getBase() - templateData.getMaxSpread()) {
            techMinimum = templateData.getBase() - templateData.getMaxSpread();
        }
        if (techMaximum > templateData.getBase() + templateData.getMaxSpread()) {
            techMaximum = templateData.getBase() + templateData.getMaxSpread();
        }
        item.addItemTag(this.getAppliedNBT(currentData));
        if (techMinimum != 0.0 || techMaximum != 0.0) {
            String builtRange = DoubleStat.formatPath(this.getPath(), this.getGeneralStatFormat(), false, false, Math.floor(techMinimum), Math.floor(techMaximum));
            item.getLore().insert(this.getPath(), builtRange);
        }
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull DoubleData data) {
        ArrayList<ItemTag> ret = new ArrayList<ItemTag>();
        ret.add(new ItemTag(this.getNBTPath(), (Object)data.getValue()));
        return ret;
    }

    @Override
    public RandomRequiredLevelData whenInitialized(Object object) {
        return new RandomRequiredLevelData(object);
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        DoubleData data;
        ArrayList<ItemTag> tags = new ArrayList<ItemTag>();
        if (mmoitem.getNBT().hasTag(this.getNBTPath())) {
            tags.add(ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.DOUBLE));
        }
        if ((data = this.getLoadedNBT((ArrayList)tags)) != null) {
            mmoitem.setData(this, data);
        }
    }

    @Override
    @Nullable
    public RequiredLevelData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag rTag = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (rTag != null) {
            return new RequiredLevelData((Double)rTag.getValue());
        }
        return null;
    }

    @Override
    public RequiredLevelData getClearStatData() {
        return new RequiredLevelData(0.0);
    }
}

