/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.type;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.ItemTag;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.annotation.VersionDependant;
import net.Indyuce.mmoitems.stat.category.StatCategory;
import net.Indyuce.mmoitems.stat.data.random.RandomStatData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ItemStat<R extends RandomStatData<S>, S extends StatData> {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final String configPath;
    @NotNull
    private final String nbtPath;
    @NotNull
    private final Material material;
    private final String[] lore;
    private final List<String> compatibleTypes;
    private final List<Material> compatibleMaterials;
    @NotNull
    private String[] aliases = new String[0];
    private boolean enabled = true;
    private StatCategory category;
    protected static final int LORE_LINE_WIDTH = 50;
    protected String generalStatFormat;

    public ItemStat(@NotNull String id, @NotNull Material material, @NotNull String name, @Nullable String[] lore, @Nullable String[] types, Material ... materials) {
        Annotation implVersion;
        this.id = id;
        this.material = material;
        this.lore = lore == null ? new String[]{} : lore;
        this.compatibleTypes = types == null ? new ArrayList() : Arrays.asList(types);
        this.name = name;
        this.compatibleMaterials = Arrays.asList(materials);
        this.configPath = id.toLowerCase().replace("_", "-");
        this.nbtPath = "MMOITEMS_" + id;
        if (this.getClass().isAnnotationPresent(VersionDependant.class)) {
            implVersion = this.getClass().getAnnotation(VersionDependant.class);
            if (MythicLib.plugin.getVersion().isUnder(implVersion.version())) {
                this.disable();
            }
        }
        if (this.getClass().isAnnotationPresent(net.Indyuce.mmoitems.util.VersionDependant.class)) {
            implVersion = this.getClass().getAnnotation(net.Indyuce.mmoitems.util.VersionDependant.class);
            if (MythicLib.plugin.getVersion().isUnder(implVersion.version())) {
                this.disable();
            }
        }
    }

    public abstract R whenInitialized(Object var1);

    public abstract void whenApplied(@NotNull ItemStackBuilder var1, @NotNull S var2);

    @NotNull
    public abstract ArrayList<ItemTag> getAppliedNBT(@NotNull S var1);

    public abstract void whenClicked(@NotNull EditionInventory var1, @NotNull InventoryClickEvent var2);

    public abstract void whenInput(@NotNull EditionInventory var1, @NotNull String var2, Object ... var3);

    public abstract void whenLoaded(@NotNull ReadMMOItem var1);

    @Nullable
    public abstract S getLoadedNBT(@NotNull ArrayList<ItemTag> var1);

    public abstract void whenDisplayed(List<String> var1, Optional<R> var2);

    public void loadConfiguration(@NotNull ConfigurationSection legacyLanguageFile, @NotNull Object configObject) {
        this.loadConfiguration(configObject);
    }

    public void loadConfiguration(@NotNull Object configObject) {
        this.generalStatFormat = configObject.toString();
    }

    public String getLegacyTranslationPath() {
        return this.getPath();
    }

    public String getGeneralStatFormat() {
        return this.generalStatFormat;
    }

    @Nullable
    public StatCategory getCategory() {
        return this.category;
    }

    public void setCategory(@Nullable StatCategory category) {
        this.category = category;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String[] getAliases() {
        return this.aliases;
    }

    public void setAliases(String ... aliases) {
        this.aliases = aliases;
    }

    @Deprecated
    @NotNull
    public String name() {
        return this.id;
    }

    @NotNull
    public String getPath() {
        return this.configPath;
    }

    @NotNull
    public String getNBTPath() {
        return this.nbtPath;
    }

    public Material getDisplayMaterial() {
        return this.material;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String[] getLore() {
        return this.lore;
    }

    @NotNull
    public List<String> getCompatibleTypes() {
        return this.compatibleTypes;
    }

    public boolean isCompatible(@NotNull Type type) {
        if (this.compatibleTypes.isEmpty()) {
            return true;
        }
        if (type.getModifierSource().isWeapon() && this.compatibleTypes.contains("weapon")) {
            return true;
        }
        if (type.getModifierSource().isEquipment() && this.compatibleTypes.contains("equipment")) {
            return true;
        }
        if (type.getModifierSource().isHandheld() && this.compatibleTypes.contains("handheld")) {
            return true;
        }
        String lower = type.getSupertype().getId().toLowerCase();
        return !this.compatibleTypes.contains("!" + lower) && (this.compatibleTypes.contains("all") || this.compatibleTypes.contains(lower));
    }

    public boolean hasValidMaterial(ItemStack item) {
        return this.compatibleMaterials.isEmpty() || this.compatibleMaterials.contains(item.getType());
    }

    public void disable() {
        this.enabled = false;
    }

    @Deprecated
    public String formatNumericStat(double value, String ... replace) {
        String format = this.getGeneralStatFormat().replace("<plus>", value > 0.0 ? "+" : "");
        for (int j = 0; j < replace.length; j += 2) {
            format = format.replace(replace[j], replace[j + 1]);
        }
        return format;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStat itemStat = (ItemStat)o;
        return this.id.equals(itemStat.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Deprecated
    public static String translate(String path) {
        return MMOItems.plugin.getLanguage().getStatFormat(path);
    }

    @NotNull
    public abstract S getClearStatData();
}

