/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.data.random;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.Indyuce.mmoitems.api.item.build.MMOItemBuilder;
import net.Indyuce.mmoitems.api.util.NumericStatFormula;
import net.Indyuce.mmoitems.stat.Enchants;
import net.Indyuce.mmoitems.stat.data.EnchantListData;
import net.Indyuce.mmoitems.stat.data.random.RandomStatData;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;

public class RandomEnchantListData
implements RandomStatData<EnchantListData> {
    private final Map<Enchantment, NumericStatFormula> enchants = new HashMap<Enchantment, NumericStatFormula>();

    public RandomEnchantListData(ConfigurationSection config) {
        Validate.notNull((Object)config, (String)"Config cannot be null");
        for (String key : config.getKeys(false)) {
            Enchantment enchant = Enchants.getEnchant(key);
            Validate.notNull((Object)enchant, (String)("Could not find enchant with key '" + key + "'"));
            this.addEnchant(enchant, new NumericStatFormula(config.get(key)));
        }
    }

    public Set<Enchantment> getEnchants() {
        return this.enchants.keySet();
    }

    public NumericStatFormula getLevel(Enchantment enchant) {
        return this.enchants.get(enchant);
    }

    public void addEnchant(Enchantment enchant, NumericStatFormula formula) {
        this.enchants.put(enchant, formula);
    }

    @Override
    public EnchantListData randomize(MMOItemBuilder builder) {
        EnchantListData list = new EnchantListData();
        this.enchants.forEach((enchant, formula) -> list.addEnchant((Enchantment)enchant, (int)Math.max(formula.calculate(builder.getLevel()), (double)enchant.getStartLevel())));
        return list;
    }
}

