/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.data.random;

import io.lumine.mythic.lib.element.Element;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.Indyuce.mmoitems.api.item.build.MMOItemBuilder;
import net.Indyuce.mmoitems.api.util.NumericStatFormula;
import net.Indyuce.mmoitems.stat.data.DoubleData;
import net.Indyuce.mmoitems.stat.data.ElementListData;
import net.Indyuce.mmoitems.stat.data.random.RandomStatData;
import net.Indyuce.mmoitems.stat.data.random.UpdatableRandomStatData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.util.ElementStatType;
import net.Indyuce.mmoitems.util.Pair;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public class RandomElementListData
implements RandomStatData<ElementListData>,
UpdatableRandomStatData<ElementListData> {
    private final Map<Pair<Element, ElementStatType>, NumericStatFormula> stats = new LinkedHashMap<Pair<Element, ElementStatType>, NumericStatFormula>();

    public RandomElementListData(ConfigurationSection config) {
        Validate.notNull((Object)config, (String)"Config cannot be null");
        for (Element element : Element.values()) {
            for (ElementStatType statType : ElementStatType.values()) {
                String path = statType.getConcatenatedConfigPath(element);
                if (!config.contains(path)) continue;
                this.stats.put(Pair.of(element, statType), new NumericStatFormula(config.get(path)));
            }
        }
    }

    public boolean hasStat(Element element, ElementStatType statType) {
        return this.stats.containsKey(Pair.of(element, statType));
    }

    @NotNull
    public NumericStatFormula getStat(Element element, ElementStatType statType) {
        return this.stats.getOrDefault(Pair.of(element, statType), NumericStatFormula.ZERO);
    }

    public Set<Pair<Element, ElementStatType>> getKeys() {
        return this.stats.keySet();
    }

    public void setStat(Element element, ElementStatType statType, NumericStatFormula formula) {
        this.stats.put(Pair.of(element, statType), formula);
    }

    @Override
    public ElementListData randomize(MMOItemBuilder builder) {
        ElementListData elements = new ElementListData();
        this.stats.forEach((key, value) -> elements.setStat((Element)key.getKey(), (ElementStatType)((Object)((Object)key.getValue())), value.calculate(builder.getLevel())));
        return elements;
    }

    @Override
    @NotNull
    public ElementListData reroll(@NotNull ItemStat stat, @NotNull ElementListData original, int determinedItemLevel) {
        ElementListData elements = new ElementListData();
        ElementListData originalElements = original;
        for (Element element : Element.values()) {
            for (ElementStatType statType : ElementStatType.values()) {
                NumericStatFormula currentTemplateData = this.getStat(element, statType);
                DoubleData itemData = new DoubleData(originalElements.getStat(element, statType));
                DoubleData result = currentTemplateData.reroll(stat, itemData, determinedItemLevel);
                elements.setStat(element, statType, result.getValue());
            }
        }
        return elements;
    }
}

