/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.data;

import io.lumine.mythic.lib.gson.JsonObject;
import java.util.UUID;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SoulboundData
implements StatData {
    private final UUID uuid;
    private final String name;
    private final int level;

    public SoulboundData(Player player, int level) {
        this(player.getUniqueId(), player.getName(), level);
    }

    public SoulboundData(UUID uuid, String name, int level) {
        this.uuid = uuid;
        this.name = name;
        this.level = level;
    }

    public SoulboundData(JsonObject object) {
        this.uuid = UUID.fromString(object.get("UUID").getAsString());
        this.name = object.get("Name").getAsString();
        this.level = object.get("Level").getAsInt();
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public int getLevel() {
        return this.level;
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("Level", (Number)this.level);
        object.addProperty("Name", this.name);
        object.addProperty("UUID", this.uuid.toString());
        return object;
    }

    @NotNull
    public StatData clone() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

