/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.data;

import io.lumine.mythic.lib.gson.JsonElement;
import io.lumine.mythic.lib.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.api.item.mmoitem.LiveMMOItem;
import net.Indyuce.mmoitems.stat.data.AbilityData;
import net.Indyuce.mmoitems.stat.data.AbilityListData;
import net.Indyuce.mmoitems.stat.data.PotionEffectData;
import net.Indyuce.mmoitems.stat.data.PotionEffectListData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GemstoneData {
    private final Set<AbilityData> abilities = new HashSet<AbilityData>();
    private final List<PotionEffectData> effects = new ArrayList<PotionEffectData>();
    private final Map<ItemStat, Double> stats = new HashMap<ItemStat, Double>();
    private final String name;
    @NotNull
    private final UUID historicUUID;
    @Nullable
    private final String mmoitemType;
    @Nullable
    private final String mmoitemID;
    @Nullable
    private String socketColor;
    @Nullable
    private Integer levelPut;

    public GemstoneData cloneGem() {
        GemstoneData ret = new GemstoneData(this.getName(), this.getMMOItemType(), this.getMMOItemID(), this.getSocketColor(), this.getHistoricUUID());
        for (AbilityData abilityData : this.abilities) {
            ret.addAbility(abilityData);
        }
        for (PotionEffectData potionEffectData : this.effects) {
            ret.addPermanentEffect(potionEffectData);
        }
        for (ItemStat itemStat : this.stats.keySet()) {
            ret.setStat(itemStat, this.stats.get(itemStat));
        }
        ret.setLevel(this.getLevel());
        return ret;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GemstoneData)) {
            return false;
        }
        return ((GemstoneData)obj).getHistoricUUID().equals(this.getHistoricUUID());
    }

    @Nullable
    public String getMMOItemType() {
        return this.mmoitemType;
    }

    @Nullable
    public String getMMOItemID() {
        return this.mmoitemID;
    }

    @Nullable
    public String getSocketColor() {
        return this.socketColor;
    }

    public GemstoneData(@NotNull JsonObject object) {
        this.name = object.get("Name").getAsString();
        JsonElement uuid = object.get("History");
        if (uuid != null) {
            String hUUID = uuid.getAsString();
            UUID hisUUID = MMOUtils.UUIDFromString(hUUID);
            this.historicUUID = hisUUID != null ? hisUUID : UUID.randomUUID();
            JsonElement gType = object.get("Type");
            JsonElement gID = object.get("Id");
            this.mmoitemType = gType != null ? gType.getAsString() : null;
            this.mmoitemID = gID != null ? gID.getAsString() : null;
            JsonElement level = object.get("Level");
            this.levelPut = level != null && level.isJsonPrimitive() ? Integer.valueOf(level.getAsJsonPrimitive().getAsInt()) : null;
            JsonElement color = object.get("Color");
            this.socketColor = color != null && color.isJsonPrimitive() ? color.getAsJsonPrimitive().getAsString() : null;
        } else {
            this.historicUUID = UUID.randomUUID();
            this.mmoitemID = null;
            this.mmoitemType = null;
            this.socketColor = null;
        }
    }

    public GemstoneData(@NotNull LiveMMOItem gemStoneMMOItem, @Nullable String color) {
        this(gemStoneMMOItem, color, UUID.randomUUID());
    }

    public GemstoneData(@NotNull LiveMMOItem gemStoneMMOItem, @Nullable String color, @NotNull UUID forcedHistoryUUID) {
        this.name = MMOUtils.getDisplayName(gemStoneMMOItem.getNBT().getItem());
        if (gemStoneMMOItem.hasData(ItemStats.ABILITIES)) {
            this.abilities.addAll(((AbilityListData)gemStoneMMOItem.getData(ItemStats.ABILITIES)).getAbilities());
        }
        if (gemStoneMMOItem.hasData(ItemStats.PERM_EFFECTS)) {
            this.effects.addAll(((PotionEffectListData)gemStoneMMOItem.getData(ItemStats.PERM_EFFECTS)).getEffects());
        }
        this.historicUUID = forcedHistoryUUID;
        this.mmoitemID = gemStoneMMOItem.getId();
        this.mmoitemType = gemStoneMMOItem.getType().getId();
        this.socketColor = color;
    }

    public GemstoneData(@NotNull String name) {
        this.name = name;
        this.mmoitemID = null;
        this.mmoitemType = null;
        this.socketColor = null;
        this.historicUUID = UUID.randomUUID();
    }

    public void setLevel(@Nullable Integer l) {
        this.levelPut = l;
    }

    @Nullable
    public Integer getLevel() {
        return this.levelPut;
    }

    public boolean isScaling() {
        return this.levelPut != null;
    }

    public GemstoneData(@NotNull String name, @Nullable String type, @Nullable String id, @Nullable String color) {
        this.name = name;
        this.mmoitemID = id;
        this.mmoitemType = type;
        this.socketColor = color;
        this.historicUUID = UUID.randomUUID();
    }

    public GemstoneData(@NotNull String name, @Nullable String type, @Nullable String id, @Nullable String color, @NotNull UUID uiid) {
        this.name = name;
        this.mmoitemID = id;
        this.mmoitemType = type;
        this.socketColor = color;
        this.historicUUID = uiid;
    }

    public void addAbility(@NotNull AbilityData ability) {
        this.abilities.add(ability);
    }

    public void addPermanentEffect(@NotNull PotionEffectData effect) {
        this.effects.add(effect);
    }

    public void setStat(@NotNull ItemStat stat, double value) {
        this.stats.put(stat, value);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setColour(@Nullable String color) {
        this.socketColor = color;
    }

    @NotNull
    public UUID getHistoricUUID() {
        return this.historicUUID;
    }

    @NotNull
    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("Name", this.name);
        object.addProperty("History", this.historicUUID.toString());
        if (this.mmoitemID != null) {
            object.addProperty("Id", this.mmoitemID);
        }
        if (this.mmoitemType != null) {
            object.addProperty("Type", this.mmoitemType);
        }
        if (this.levelPut != null) {
            object.addProperty("Level", (Number)this.levelPut);
        }
        object.addProperty("Color", this.socketColor);
        return object;
    }
}

