/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.data;

import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import io.lumine.mythic.lib.gson.JsonArray;
import io.lumine.mythic.lib.gson.JsonElement;
import io.lumine.mythic.lib.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.item.build.MMOItemBuilder;
import net.Indyuce.mmoitems.stat.data.GemstoneData;
import net.Indyuce.mmoitems.stat.data.random.RandomStatData;
import net.Indyuce.mmoitems.stat.data.type.Mergeable;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GemSocketsData
implements StatData,
Mergeable<GemSocketsData>,
RandomStatData<GemSocketsData> {
    @NotNull
    private final List<GemstoneData> gems = new ArrayList<GemstoneData>();
    @NotNull
    private final List<String> emptySlots;

    public GemSocketsData(@NotNull List<String> emptySlots) {
        this.emptySlots = emptySlots;
    }

    public GemSocketsData(@NotNull JsonArray emptySlots) {
        this.emptySlots = new ArrayList<String>();
        emptySlots.forEach(el -> this.emptySlots.add(el.getAsString()));
    }

    public boolean canReceive(@NotNull String gem) {
        return this.getEmptySocket(gem) != null;
    }

    @Nullable
    public String getEmptySocket(@NotNull String gem) {
        for (String slot : this.emptySlots) {
            if (!gem.isEmpty() && !slot.equals(GemSocketsData.getUncoloredGemSlot()) && !gem.equals(slot)) continue;
            return slot;
        }
        return null;
    }

    @NotNull
    public static String getUncoloredGemSlot() {
        String s = MMOItems.plugin.getConfig().getString("gem-sockets.uncolored");
        return s == null ? "Uncolored" : s;
    }

    public void add(GemstoneData gem) {
        this.gems.add(gem);
    }

    public boolean apply(String gem, GemstoneData gemstone) {
        String matchingSocket = this.getEmptySocket(gem);
        if (matchingSocket == null) {
            return false;
        }
        this.emptySlots.remove(matchingSocket);
        this.gems.add(gemstone);
        return true;
    }

    public void addEmptySlot(@NotNull String slot) {
        this.emptySlots.add(slot);
    }

    @NotNull
    public List<String> getEmptySlots() {
        return this.emptySlots;
    }

    @Deprecated
    public Set<GemstoneData> getGemstones() {
        return new HashSet<GemstoneData>(this.gems);
    }

    @NotNull
    public List<GemstoneData> getGems() {
        return this.gems;
    }

    public boolean removeGem(@NotNull UUID gemId, @Nullable String socket) {
        for (GemstoneData data : this.getGemstones()) {
            if (!data.getHistoricUUID().equals(gemId)) continue;
            if (socket != null) {
                this.addEmptySlot(socket);
            }
            this.gems.remove(data);
            return true;
        }
        return false;
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        JsonArray empty = new JsonArray();
        this.getEmptySlots().forEach(arg_0 -> ((JsonArray)empty).add(arg_0));
        object.add("EmptySlots", (JsonElement)empty);
        JsonArray array = new JsonArray();
        this.gems.forEach(gem -> array.add((JsonElement)gem.toJson()));
        object.add("Gemstones", (JsonElement)array);
        return object;
    }

    @Override
    public void mergeWith(GemSocketsData data) {
        this.emptySlots.addAll(data.emptySlots);
        this.gems.addAll(data.gems);
    }

    @Override
    public GemSocketsData clone() {
        GemSocketsData ret = new GemSocketsData(new ArrayList<String>(this.emptySlots));
        for (GemstoneData gem : this.getGemstones()) {
            ret.add(gem.cloneGem());
        }
        return ret;
    }

    @Override
    public boolean isEmpty() {
        return this.gems.isEmpty() && this.emptySlots.isEmpty();
    }

    @Override
    public GemSocketsData randomize(MMOItemBuilder builder) {
        return new GemSocketsData(new ArrayList<String>(this.emptySlots));
    }

    public String toString() {
        return "Empty:\u00a7b " + this.getEmptySlots().size() + "\u00a77, Gems:\u00a7b " + this.getGemstones().size();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GemSocketsData)) {
            return false;
        }
        if (((GemSocketsData)obj).getEmptySlots().size() != this.getEmptySlots().size()) {
            return false;
        }
        if (((GemSocketsData)obj).getGemstones().size() != this.getGemstones().size()) {
            return false;
        }
        if (!SilentNumbers.hasAll(((GemSocketsData)obj).getEmptySlots(), this.getEmptySlots())) {
            return false;
        }
        for (GemstoneData objGem : ((GemSocketsData)obj).getGemstones()) {
            if (objGem == null) continue;
            boolean unmatched = true;
            for (GemstoneData thisGem : this.getGemstones()) {
                if (!objGem.equals(thisGem)) continue;
                unmatched = false;
                break;
            }
            if (!unmatched) continue;
            return false;
        }
        return true;
    }
}

