/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.stat.data.MaterialData;
import net.Indyuce.mmoitems.stat.data.type.Mergeable;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.jetbrains.annotations.NotNull;

public class EnchantListData
implements StatData,
Mergeable<EnchantListData> {
    private final Map<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();

    @NotNull
    public Set<Enchantment> getEnchants() {
        return this.enchants.keySet();
    }

    public int getLevel(@NotNull Enchantment enchant) {
        Integer found = this.enchants.get(enchant);
        return found == null ? 0 : found;
    }

    public void addEnchant(Enchantment enchant, int level) {
        if (level <= 0) {
            this.enchants.remove(enchant);
        } else {
            this.enchants.put(enchant, level);
        }
    }

    public void clear() {
        this.enchants.clear();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EnchantListData)) {
            return false;
        }
        if (((EnchantListData)obj).enchants.size() != this.enchants.size()) {
            return false;
        }
        for (Enchantment e : this.getEnchants()) {
            if (this.getLevel(e) == ((EnchantListData)obj).getLevel(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void mergeWith(@NotNull EnchantListData targetData) {
        for (Enchantment enchant : targetData.getEnchants()) {
            this.addEnchant(enchant, Math.max(this.enchants.getOrDefault(enchant, 0), targetData.getLevel(enchant)));
        }
    }

    @Override
    @NotNull
    public EnchantListData clone() {
        EnchantListData ret = new EnchantListData();
        for (Enchantment enchant : this.enchants.keySet()) {
            ret.addEnchant(enchant, this.enchants.getOrDefault(enchant, 0));
        }
        return ret;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("EnchantList{");
        AtomicBoolean check = new AtomicBoolean();
        this.enchants.forEach((enchant, lvl) -> {
            if (check.get()) {
                builder.append(",");
            }
            builder.append(enchant).append("=").append(lvl);
            check.set(true);
        });
        builder.append("}");
        return builder.toString();
    }

    @Override
    public boolean isEmpty() {
        for (int level : this.enchants.values()) {
            if (level <= 0) continue;
            return false;
        }
        return true;
    }

    public void identifyTrueOriginalEnchantments(@NotNull MMOItem mmoItem) {
        if (mmoItem.hasData(ItemStats.DISABLE_ENCHANTING) && mmoItem.hasData(ItemStats.DISABLE_REPAIRING)) {
            this.clear();
            return;
        }
        EnchantListData mmoData = (EnchantListData)mmoItem.computeData(ItemStats.ENCHANTS);
        if (mmoData.getEnchants().size() == 0) {
            mmoItem.mergeData(ItemStats.ENCHANTS, this, null);
            return;
        }
        EnchantListData processed = new EnchantListData();
        mmoItem.hasData(ItemStats.MATERIAL);
        MaterialData mData = (MaterialData)mmoItem.getData(ItemStats.MATERIAL);
        Material mat = mData.getMaterial();
        for (Enchantment e : this.getEnchants()) {
            int current = this.getLevel(e);
            int updated = mmoData.getLevel(e);
            if (updated > e.getMaxLevel() || !e.getItemTarget().includes(mat) || updated >= current) continue;
            processed.addEnchant(e, current);
        }
        if (!processed.isEmpty()) {
            mmoItem.mergeData(ItemStats.ENCHANTS, processed, null);
        }
    }
}

