/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.data;

import io.lumine.mythic.lib.element.Element;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.Indyuce.mmoitems.stat.data.type.Mergeable;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.util.ElementStatType;
import net.Indyuce.mmoitems.util.Pair;
import org.jetbrains.annotations.NotNull;

public class ElementListData
implements StatData,
Mergeable<ElementListData> {
    private final Map<Pair<Element, ElementStatType>, Double> stats = new LinkedHashMap<Pair<Element, ElementStatType>, Double>();

    public double getStat(Element element, ElementStatType statType) {
        Double found = this.stats.get(Pair.of(element, statType));
        return found == null ? 0.0 : found;
    }

    public Set<Pair<Element, ElementStatType>> getKeys() {
        return this.stats.keySet();
    }

    public void setStat(Element element, ElementStatType statType, double value) {
        this.stats.put(Pair.of(element, statType), value);
    }

    @Override
    public void mergeWith(@NotNull ElementListData targetData) {
        targetData.stats.forEach((key, value) -> this.stats.put((Pair<Element, ElementStatType>)key, value + this.stats.getOrDefault(key, 0.0)));
    }

    @Override
    @NotNull
    public ElementListData clone() {
        ElementListData ret = new ElementListData();
        for (Map.Entry<Pair<Element, ElementStatType>, Double> entry : this.stats.entrySet()) {
            Pair<Element, ElementStatType> key = entry.getKey();
            Double value = entry.getValue();
            if (value == 0.0) continue;
            ret.stats.put(key, value);
        }
        return ret;
    }

    @Override
    public boolean isEmpty() {
        return this.stats.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElementListData that = (ElementListData)o;
        return this.stats.equals(that.stats);
    }

    public int hashCode() {
        return Objects.hash(this.stats);
    }
}

