/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import java.util.ArrayList;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.stat.data.BooleanData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.BooleanStat;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Unbreakable
extends BooleanStat {
    public Unbreakable() {
        super("UNBREAKABLE", Material.ANVIL, "Unbreakable", new String[]{"Infinite durability if set to true."}, new String[0], new Material[0]);
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull BooleanData data) {
        if (data.isEnabled()) {
            item.getMeta().setUnbreakable(true);
            item.addItemTag(this.getAppliedNBT(data));
            item.getMeta().addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        }
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull BooleanData data) {
        ArrayList<ItemTag> a = new ArrayList<ItemTag>();
        if (data.isEnabled()) {
            a.add(new ItemTag(this.getNBTPath(), (Object)true));
        }
        return a;
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        StatData data;
        ArrayList<ItemTag> rTags = new ArrayList<ItemTag>();
        if (mmoitem.getNBT().hasTag(this.getNBTPath())) {
            rTags.add(ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.BOOLEAN));
        }
        if ((data = this.getLoadedNBT((ArrayList)rTags)) != null) {
            mmoitem.setData(this, data);
        }
    }

    @Override
    @Nullable
    public BooleanData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag uTag = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (uTag != null) {
            return new BooleanData((Boolean)uTag.getValue());
        }
        return null;
    }

    @Override
    @NotNull
    public String getNBTPath() {
        return "Unbreakable";
    }
}

