/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.version.Sounds;
import java.util.Random;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.event.item.BreakSoulboundEvent;
import net.Indyuce.mmoitems.api.interaction.Consumable;
import net.Indyuce.mmoitems.api.item.mmoitem.LiveMMOItem;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.api.item.mmoitem.VolatileMMOItem;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.stat.annotation.HasCategory;
import net.Indyuce.mmoitems.stat.data.SoulboundData;
import net.Indyuce.mmoitems.stat.type.ConsumableItemInteraction;
import net.Indyuce.mmoitems.stat.type.DoubleStat;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;

@HasCategory(cat="soulbound")
public class SoulbindingBreakChance
extends DoubleStat
implements ConsumableItemInteraction {
    private static final Random RANDOM = new Random();

    public SoulbindingBreakChance() {
        super("SOULBOUND_BREAK_CHANCE", Material.ENDER_EYE, "Soulbound Break Chance", new String[]{"The chance of breaking an item's", "soulbound when drag & drop'd on it.", "This chance is lowered depending", "on the soulbound's level."}, new String[]{"consumable"}, new Material[0]);
    }

    @Override
    public boolean handleConsumableEffect(@NotNull InventoryClickEvent event, @NotNull PlayerData playerData, @NotNull Consumable consumable, @NotNull NBTItem target, Type targetType) {
        Player player = playerData.getPlayer();
        double soulboundBreakChance = consumable.getNBTItem().getStat("SOULBOUND_BREAK_CHANCE");
        if (soulboundBreakChance <= 0.0) {
            return false;
        }
        ReadMMOItem targetMMO = new VolatileMMOItem(target);
        if (!targetMMO.hasData(ItemStats.SOULBOUND)) {
            Message.NO_SOULBOUND.format(ChatColor.RED, new String[0]).send(player);
            player.playSound(player.getLocation(), Sounds.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            return false;
        }
        SoulboundData soulbound = (SoulboundData)targetMMO.getData(ItemStats.SOULBOUND);
        if (Math.max(1.0, consumable.getNBTItem().getStat(ItemStats.SOULBOUND_LEVEL.getId())) < (double)soulbound.getLevel()) {
            Message.LOW_SOULBOUND_LEVEL.format(ChatColor.RED, "#level#", MMOUtils.intToRoman(soulbound.getLevel())).send(player);
            return false;
        }
        if (RANDOM.nextDouble() < soulboundBreakChance / 100.0) {
            BreakSoulboundEvent called = new BreakSoulboundEvent(playerData, consumable.getMMOItem(), target);
            Bukkit.getPluginManager().callEvent((Event)called);
            if (called.isCancelled()) {
                return false;
            }
            targetMMO = new LiveMMOItem(target);
            targetMMO.removeData(ItemStats.SOULBOUND);
            target.getItem().setItemMeta(targetMMO.newBuilder().build().getItemMeta());
            Message.SUCCESSFULLY_BREAK_BIND.format(ChatColor.YELLOW, "#level#", MMOUtils.intToRoman(soulbound.getLevel())).send(player);
            player.playSound(player.getLocation(), Sounds.BLOCK_ANVIL_LAND, 1.0f, 2.0f);
        } else {
            Message.UNSUCCESSFUL_SOULBOUND_BREAK.format(ChatColor.RED, new String[0]).send(player);
            player.playSound(player.getLocation(), Sounds.ENTITY_ITEM_BREAK, 1.0f, 0.0f);
        }
        return true;
    }
}

