/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.ItemTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.SkullTextureData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkullTextureStat
extends ItemStat<SkullTextureData, SkullTextureData> {
    public SkullTextureStat() {
        super("SKULL_TEXTURE", Material.PLAYER_HEAD, "Skull Texture", new String[]{"The skull texture &nvalue&7 which can be found on", "head databases. 1.20+ users can also provide the", "texture URL directly (starting with https://...)."}, new String[0], Material.PLAYER_HEAD);
    }

    @Override
    public SkullTextureData whenInitialized(Object object) {
        Validate.isTrue((boolean)(object instanceof ConfigurationSection), (String)"Must specify a config section");
        ConfigurationSection config = (ConfigurationSection)object;
        String value = config.getString("value");
        Validate.notNull((Object)value, (String)"Could not load skull texture value");
        String uuid = config.getString("uuid");
        Validate.notNull((Object)uuid, (String)"Could not find skull texture UUID: re-enter your skull texture value and one will be selected randomly.");
        Object profile = MythicLib.plugin.getVersion().getWrapper().newProfile(UUID.fromString(uuid), value);
        SkullTextureData skullTexture = new SkullTextureData(profile);
        return skullTexture;
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<SkullTextureData> statData) {
        lore.add(ChatColor.GRAY + "Current Value: " + (statData.isPresent() ? ChatColor.GREEN + "Texture value provided" : ChatColor.RED + "None"));
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Left click to change this value.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to remove this value.");
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        inv.getEditedSection().set("skull-texture.value", (Object)message);
        inv.getEditedSection().set("skull-texture.uuid", (Object)UUID.randomUUID().toString());
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + this.getName() + " successfully changed to " + message + ".");
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull SkullTextureData data) {
        if (item.getItemStack().getType() != Material.PLAYER_HEAD) {
            return;
        }
        if (data.getGameProfile() != null) {
            MythicLib.plugin.getVersion().getWrapper().setProfile((SkullMeta)item.getMeta(), data.getGameProfile());
        }
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull SkullTextureData data) {
        return new ArrayList<ItemTag>();
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.PICKUP_HALF) {
            inv.getEditedSection().set(this.getPath(), null);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Successfully removed " + this.getName() + ".");
        } else {
            new StatEdition(inv, this, new Object[0]).enable("Write in the chat the text you want.");
        }
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        try {
            ItemMeta meta = mmoitem.getNBT().getItem().getItemMeta();
            Validate.isTrue((boolean)(meta instanceof SkullMeta), (String)"Item is not a skull");
            Object profile = MythicLib.plugin.getVersion().getWrapper().getProfile((SkullMeta)meta);
            mmoitem.setData(ItemStats.SKULL_TEXTURE, new SkullTextureData(profile));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    @Nullable
    public SkullTextureData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        return null;
    }

    @Override
    @NotNull
    public SkullTextureData getClearStatData() {
        return new SkullTextureData(null);
    }
}

