/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.item.ItemTag;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.HidePotionEffects;
import net.Indyuce.mmoitems.stat.data.ShieldPatternData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShieldPatternStat
extends ItemStat<ShieldPatternData, ShieldPatternData> {
    private final Method PatternType__valueOf;
    private final Method PatternType__name;

    public ShieldPatternStat() {
        super("SHIELD_PATTERN", Material.SHIELD, "Shield Pattern", new String[]{"The color & patterns", "of your shield."}, new String[0], Material.SHIELD);
        try {
            this.PatternType__valueOf = PatternType.class.getDeclaredMethod("valueOf", String.class);
            this.PatternType__name = PatternType.class.getMethod("name", new Class[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException("Reflection error: " + exception.getMessage());
        }
    }

    private PatternType PatternType__valueOf(String str) {
        try {
            return (PatternType)this.PatternType__valueOf.invoke(null, str);
        }
        catch (Exception exception) {
            throw new RuntimeException("Reflection exception", exception);
        }
    }

    private String PatternType__name(PatternType type) {
        try {
            return (String)this.PatternType__name.invoke((Object)type, new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException("Reflection exception", exception);
        }
    }

    @Override
    public ShieldPatternData whenInitialized(Object object) {
        Validate.isTrue((boolean)(object instanceof ConfigurationSection), (String)"Must specify a config section");
        ConfigurationSection config = (ConfigurationSection)object;
        ShieldPatternData shieldPattern = new ShieldPatternData(config.contains("color") ? DyeColor.valueOf((String)config.getString("color").toUpperCase().replace("-", "_").replace(" ", "_")) : null, new Pattern[0]);
        for (String key : config.getKeys(false)) {
            if (key.equalsIgnoreCase("color")) continue;
            String format = config.getString(key + ".pattern").toUpperCase().replace("-", "_").replace(" ", "_");
            PatternType type = this.PatternType__valueOf(format);
            format = config.getString(key + ".color").toUpperCase().replace("-", "_").replace(" ", "_");
            DyeColor color = DyeColor.valueOf((String)format);
            shieldPattern.add(new Pattern(color, type));
        }
        return shieldPattern;
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull ShieldPatternData data) {
        BlockStateMeta meta = (BlockStateMeta)item.getMeta();
        Banner banner = (Banner)meta.getBlockState();
        banner.setBaseColor(data.getBaseColor());
        banner.setPatterns(data.getPatterns());
        ((BlockStateMeta)item.getMeta()).setBlockState((BlockState)banner);
        item.getMeta().addItemFlags(new ItemFlag[]{HidePotionEffects.ITEM_FLAG});
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull ShieldPatternData data) {
        return new ArrayList<ItemTag>();
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.PICKUP_ALL) {
            new StatEdition(inv, ItemStats.SHIELD_PATTERN, 0).enable("Write in the chat the color of your shield.");
        }
        if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            inv.getEditedSection().set("shield-pattern.color", null);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Successfully reset the shield color.");
        }
        if (event.getAction() == InventoryAction.PICKUP_HALF) {
            new StatEdition(inv, ItemStats.SHIELD_PATTERN, 1).enable("Write in the chat the pattern you want to add.", ChatColor.AQUA + "Format: [PATTERN_TYPE] [DYE_COLOR]");
        }
        if (event.getAction() == InventoryAction.DROP_ONE_SLOT && inv.getEditedSection().contains("shield-pattern")) {
            Set set = inv.getEditedSection().getConfigurationSection("shield-pattern").getKeys(false);
            String last = (String)new ArrayList(set).get(set.size() - 1);
            if (last.equalsIgnoreCase("color")) {
                return;
            }
            inv.getEditedSection().set("shield-pattern." + last, null);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Successfully removed the last pattern.");
        }
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        int editedStatData = (Integer)info[0];
        if (editedStatData == 1) {
            String[] split = message.split(" ");
            Validate.isTrue((split.length == 2 ? 1 : 0) != 0, (String)(message + " is not a valid [PATTERN_TYPE] [DYE_COLOR]."));
            PatternType patternType = this.PatternType__valueOf(split[0].toUpperCase().replace("-", "_").replace(" ", "_"));
            DyeColor dyeColor = DyeColor.valueOf((String)split[1].toUpperCase().replace("-", "_").replace(" ", "_"));
            int availableKey = this.getNextAvailableKey(inv.getEditedSection().getConfigurationSection("shield-pattern"));
            Validate.isTrue((availableKey >= 0 ? 1 : 0) != 0, (String)"You can have more than 100 shield patterns on a single item.");
            inv.getEditedSection().set("shield-pattern." + availableKey + ".pattern", (Object)this.PatternType__name(patternType));
            inv.getEditedSection().set("shield-pattern." + availableKey + ".color", (Object)dyeColor.name());
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + UtilityMethods.caseOnWords((String)this.PatternType__name(patternType).toLowerCase().replace("_", " ")) + " successfully added.");
            return;
        }
        DyeColor color = DyeColor.valueOf((String)message.toUpperCase().replace("-", "_").replace(" ", "_"));
        inv.getEditedSection().set("shield-pattern.color", (Object)color.name());
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Shield color successfully changed.");
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<ShieldPatternData> statData) {
        if (statData.isPresent()) {
            lore.add(ChatColor.GRAY + "Current Value:");
            ShieldPatternData data = statData.get();
            lore.add(ChatColor.GRAY + "* Base Color: " + (data.getBaseColor() != null ? ChatColor.GREEN + UtilityMethods.caseOnWords((String)data.getBaseColor().name().toLowerCase().replace("_", " ")) : ChatColor.RED + "None"));
            data.getPatterns().forEach(pattern -> lore.add(ChatColor.GRAY + "* " + ChatColor.GREEN + this.PatternType__name(pattern.getPattern()) + ChatColor.GRAY + " - " + ChatColor.GREEN + pattern.getColor().name()));
        } else {
            lore.add(ChatColor.GRAY + "Current Value: " + ChatColor.RED + "None");
        }
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Left Click to change the shield color.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Shift Left Click to reset the shield color.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right Click to add a pattern.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Drop to remove the last pattern.");
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        if (mmoitem.getNBT().getItem().getItemMeta() instanceof BlockStateMeta && ((BlockStateMeta)mmoitem.getNBT().getItem().getItemMeta()).hasBlockState() && ((BlockStateMeta)mmoitem.getNBT().getItem().getItemMeta()).getBlockState() instanceof Banner) {
            Banner banner = (Banner)((BlockStateMeta)mmoitem.getNBT().getItem().getItemMeta()).getBlockState();
            ShieldPatternData shieldPattern = new ShieldPatternData(banner.getBaseColor(), new Pattern[0]);
            shieldPattern.addAll(banner.getPatterns());
            mmoitem.setData(ItemStats.SHIELD_PATTERN, shieldPattern);
        }
    }

    @Override
    @NotNull
    public ShieldPatternData getClearStatData() {
        return new ShieldPatternData(DyeColor.YELLOW, new Pattern[0]);
    }

    @Override
    @Nullable
    public ShieldPatternData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        return null;
    }

    private int getNextAvailableKey(ConfigurationSection section) {
        for (int j = 0; j < 100; ++j) {
            if (section.contains("" + j)) continue;
            return j;
        }
        return -1;
    }
}

