/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import io.lumine.mythic.lib.version.Sounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.api.player.RPGPlayer;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.StringListData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.GemStoneStat;
import net.Indyuce.mmoitems.stat.type.ItemRestriction;
import net.Indyuce.mmoitems.stat.type.StringListStat;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequiredClass
extends StringListStat
implements ItemRestriction,
GemStoneStat {
    public RequiredClass() {
        super("REQUIRED_CLASS", Material.WRITABLE_BOOK, "Required Class", new String[]{"The class you need to", "profess to use your item."}, new String[]{"!block", "all"}, new Material[0]);
    }

    @Override
    public StringListData whenInitialized(Object object) {
        Validate.isTrue((boolean)(object instanceof List), (String)"Must specify a string list");
        return new StringListData((List)object);
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.PICKUP_ALL) {
            new StatEdition(inv, this, new Object[0]).enable("Write in the chat the class you want your item to support.");
        }
        if (event.getAction() == InventoryAction.PICKUP_HALF && inv.getEditedSection().getKeys(false).contains("required-class")) {
            List supportedClasses = inv.getEditedSection().getStringList("required-class");
            if (supportedClasses.size() < 1) {
                return;
            }
            String last = (String)supportedClasses.remove(supportedClasses.size() - 1);
            inv.getEditedSection().set(this.getPath(), (Object)(supportedClasses.size() == 0 ? null : supportedClasses));
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Successfully removed " + last + ".");
        }
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        List<String> lore = inv.getEditedSection().getKeys(false).contains("required-class") ? inv.getEditedSection().getStringList("required-class") : new ArrayList();
        lore.add(message);
        inv.getEditedSection().set(this.getPath(), lore);
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Required Class successfully added.");
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        StatData data;
        ArrayList<ItemTag> rtags = new ArrayList<ItemTag>();
        if (mmoitem.getNBT().hasTag(this.getNBTPath())) {
            rtags.add(ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.STRING));
        }
        if ((data = this.getLoadedNBT((ArrayList)rtags)) != null) {
            mmoitem.setData(this, data);
        }
    }

    @Override
    @Nullable
    public StringListData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag listTag = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (listTag != null) {
            return new StringListData(((String)listTag.getValue()).split(Pattern.quote(", ")));
        }
        return null;
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<StringListData> statData) {
        if (statData.isPresent()) {
            lore.add(ChatColor.GRAY + "Current Value:");
            StringListData data = statData.get();
            data.getList().forEach(el -> lore.add(ChatColor.GRAY + "* " + ChatColor.GREEN + el));
        } else {
            lore.add(ChatColor.GRAY + "Current Value: " + ChatColor.RED + "None");
        }
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Click to add a class.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to remove the last class.");
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull StringListData data) {
        ArrayList<ItemTag> ret = new ArrayList<ItemTag>();
        ret.add(new ItemTag(this.getNBTPath(), (Object)String.join((CharSequence)", ", data.getList())));
        return ret;
    }

    @Override
    public boolean canUse(RPGPlayer player, NBTItem item, boolean message) {
        String requiredClass = item.getString(ItemStats.REQUIRED_CLASS.getNBTPath());
        if (!(requiredClass.equals("") || this.hasRightClass(player, requiredClass) || player.getPlayer().hasPermission("mmoitems.bypass.class"))) {
            if (message) {
                Message.WRONG_CLASS.format(ChatColor.RED, new String[0]).send(player.getPlayer());
                player.getPlayer().playSound(player.getPlayer().getLocation(), Sounds.ENTITY_VILLAGER_NO, 1.0f, 1.5f);
            }
            return false;
        }
        return true;
    }

    private boolean hasRightClass(RPGPlayer player, String requiredClass) {
        String name = ChatColor.stripColor((String)player.getClassName());
        for (String found : requiredClass.split(Pattern.quote(", "))) {
            if (!found.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }
}

