/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import io.lumine.mythic.lib.version.Sounds;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.event.item.UnsocketGemStoneEvent;
import net.Indyuce.mmoitems.api.interaction.Consumable;
import net.Indyuce.mmoitems.api.item.mmoitem.LiveMMOItem;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.api.item.mmoitem.VolatileMMOItem;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.stat.data.DoubleData;
import net.Indyuce.mmoitems.stat.data.GemSocketsData;
import net.Indyuce.mmoitems.stat.data.GemstoneData;
import net.Indyuce.mmoitems.stat.type.ConsumableItemInteraction;
import net.Indyuce.mmoitems.stat.type.DoubleStat;
import net.Indyuce.mmoitems.util.MMOUtils;
import net.Indyuce.mmoitems.util.Pair;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RandomUnsocket
extends DoubleStat
implements ConsumableItemInteraction {
    public RandomUnsocket() {
        super("RANDOM_UNSOCKET", Material.BOWL, "Random Unsocket", new String[]{"Number of gems (rounded down)", "that will pop out of an item when", "this is applied."}, new String[]{"consumable"}, new Material[0]);
    }

    @Override
    public boolean handleConsumableEffect(@NotNull InventoryClickEvent event, @NotNull PlayerData playerData, @NotNull Consumable consumable, @NotNull NBTItem target, Type targetType) {
        VolatileMMOItem consumableVol = consumable.getMMOItem();
        if (!consumableVol.hasData(ItemStats.RANDOM_UNSOCKET)) {
            return false;
        }
        if (targetType == null) {
            return false;
        }
        VolatileMMOItem mmoVol = new VolatileMMOItem(target);
        if (!((MMOItem)mmoVol).hasData(ItemStats.GEM_SOCKETS)) {
            return false;
        }
        GemSocketsData mmoGems = (GemSocketsData)mmoVol.getData(ItemStats.GEM_SOCKETS);
        if (mmoGems == null || mmoGems.getGemstones().size() == 0) {
            return false;
        }
        Player player = playerData.getPlayer();
        LiveMMOItem mmo = new LiveMMOItem(target);
        List<Pair<GemstoneData, MMOItem>> mmoGemStones = mmo.extractGemstones();
        if (mmoGemStones.isEmpty()) {
            Message.RANDOM_UNSOCKET_GEM_TOO_OLD.format(ChatColor.YELLOW, "#item#", MMOUtils.getDisplayName(event.getCurrentItem())).send(player);
            return false;
        }
        DoubleData unsocket = (DoubleData)consumable.getMMOItem().getData(ItemStats.RANDOM_UNSOCKET);
        int s = 1;
        if (unsocket != null) {
            s = SilentNumbers.floor((double)unsocket.getValue());
        }
        UnsocketGemStoneEvent unsocketGemStoneEvent = new UnsocketGemStoneEvent(playerData, consumableVol, mmo);
        Bukkit.getServer().getPluginManager().callEvent((Event)unsocketGemStoneEvent);
        if (unsocketGemStoneEvent.isCancelled()) {
            return false;
        }
        ArrayList<ItemStack> items2Drop = new ArrayList<ItemStack>();
        while (s > 0 && !mmoGemStones.isEmpty()) {
            int randomGem = SilentNumbers.floor((double)SilentNumbers.randomRange((double)0.0, (double)mmoGemStones.size()));
            if (randomGem >= mmoGemStones.size()) {
                randomGem = mmoGemStones.size() - 1;
            }
            Pair<GemstoneData, MMOItem> pair = mmoGemStones.get(randomGem);
            MMOItem gem = pair.getValue();
            GemstoneData gemData = pair.getKey();
            mmoGemStones.remove(randomGem);
            try {
                ItemStack builtGem = gem.newBuilder().build();
                if (SilentNumbers.isAir((ItemStack)builtGem)) continue;
                items2Drop.add(builtGem);
                String chosenColor = gemData.getSocketColor() != null ? gemData.getSocketColor() : GemSocketsData.getUncoloredGemSlot();
                mmo.removeGemStone(gemData.getHistoricUUID(), chosenColor);
                --s;
                Message.RANDOM_UNSOCKET_SUCCESS.format(ChatColor.YELLOW, "#item#", MMOUtils.getDisplayName(event.getCurrentItem()), "#gem#", MMOUtils.getDisplayName(builtGem)).send(player);
            }
            catch (Throwable e) {
                MMOItems.print(Level.SEVERE, "Could not unsocket gem from item $u{0}$b: $f{1}", "Stat \u00a7eRandom Unsocket", SilentNumbers.getItemName((ItemStack)event.getCurrentItem()), e.getMessage());
            }
        }
        mmo.setData(ItemStats.GEM_SOCKETS, mmo.computeStatHistory(ItemStats.GEM_SOCKETS).recalculate(mmo.getUpgradeLevel()));
        event.setCurrentItem(mmo.newBuilder().build());
        for (ItemStack drop : player.getInventory().addItem(items2Drop.toArray(new ItemStack[0])).values()) {
            player.getWorld().dropItem(player.getLocation(), drop);
        }
        player.playSound(player.getLocation(), Sounds.BLOCK_IRON_DOOR_OPEN, 1.0f, 2.0f);
        return true;
    }
}

