/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import io.lumine.mythic.lib.gson.JsonObject;
import io.lumine.mythic.lib.gson.JsonParser;
import io.lumine.mythic.lib.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.ProjectileParticlesData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;

public class ProjectileParticles
extends ItemStat<ProjectileParticlesData, ProjectileParticlesData> {
    public ProjectileParticles() {
        super("PROJECTILE_PARTICLES", Material.LIME_STAINED_GLASS, "Projectile Particles", new String[]{"The projectile particle that your weapon shoots"}, new String[]{"lute"}, new Material[0]);
    }

    @Override
    public ProjectileParticlesData whenInitialized(Object object) {
        Validate.isTrue((boolean)(object instanceof ConfigurationSection), (String)"Must specify a valid config section");
        ConfigurationSection config = (ConfigurationSection)object;
        Validate.isTrue((boolean)config.contains("particle"), (String)"Could not find projectile particle");
        Particle particle = Particle.valueOf((String)config.getString("particle").toUpperCase().replace("-", "_").replace(" ", ""));
        return MMOUtils.isColorable(particle) ? new ProjectileParticlesData(particle, config.getInt("color.red"), config.getInt("color.green"), config.getInt("color.blue")) : new ProjectileParticlesData(particle);
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.PICKUP_HALF) {
            inv.getEditedSection().set("projectile-particles", null);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Successfully removed the projectile particle.");
        } else {
            new StatEdition(inv, this, new Object[0]).enable("Write in the chat the particle you want along with the color if applicable.", ChatColor.AQUA + "Format: {Particle} {Color}", "All particles can be found here: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/Particle.html");
        }
    }

    @Override
    @NotNull
    public ProjectileParticlesData getClearStatData() {
        return new ProjectileParticlesData(Particle.FLAME);
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<ProjectileParticlesData> statData) {
        if (statData.isPresent()) {
            ProjectileParticlesData data = statData.get();
            Particle particle = data.getParticle();
            lore.add(ChatColor.GRAY + "Current Value: " + ChatColor.GREEN + particle);
            if (MMOUtils.isColorable(particle)) {
                String colorStr = particle == Particle.NOTE ? String.valueOf(data.getRed()) : data.getRed() + " " + data.getGreen() + " " + data.getBlue();
                lore.add(ChatColor.GRAY + "Color: " + ChatColor.GREEN + colorStr);
            }
        } else {
            lore.add(ChatColor.GRAY + "Current Value: " + ChatColor.RED + "None");
        }
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Left click to change this value.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to remove this value.");
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        String[] msg = message.replace(", ", " ").replace(",", " ").split(" ");
        Particle particle = Particle.valueOf((String)msg[0].toUpperCase().replace("-", "_").replace(" ", "_"));
        if (MMOUtils.isColorable(particle)) {
            Validate.isTrue((msg.length <= 4 ? 1 : 0) != 0, (String)"Too many arguments provided.");
            if (particle.equals((Object)Particle.NOTE)) {
                Validate.isTrue((msg.length == 2 ? 1 : 0) != 0, (String)("You must provide a color for this particle.\n" + MMOItems.plugin.getPrefix() + "NOTE particle colors only take a single value between 1 and 24.\n" + MMOItems.plugin.getPrefix() + ChatColor.AQUA + "Format: {Particle} {Color}"));
                int red = Math.min(24, Math.max(1, Integer.parseInt(msg[1])));
                inv.getEditedSection().set("projectile-particles.particle", (Object)particle.name());
                inv.getEditedSection().set("projectile-particles.color.red", (Object)red);
                inv.getEditedSection().set("projectile-particles.color.green", (Object)0);
                inv.getEditedSection().set("projectile-particles.color.blue", (Object)0);
                inv.registerTemplateEdition();
                inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Particle successfully set to " + UtilityMethods.caseOnWords((String)particle.name().toLowerCase().replace("_", " ")) + " with color " + red);
            } else {
                Validate.isTrue((msg.length == 4 ? 1 : 0) != 0, (String)("You must provide a color for this particle.\n" + MMOItems.plugin.getPrefix() + ChatColor.AQUA + "Format: {Particle} {R G B}"));
                int red = msg[1] != null ? Math.min(255, Math.max(0, Integer.parseInt(msg[1]))) : 0;
                int green = msg[2] != null ? Math.min(255, Math.max(0, Integer.parseInt(msg[2]))) : 0;
                int blue = msg[3] != null ? Math.min(255, Math.max(0, Integer.parseInt(msg[3]))) : 0;
                inv.getEditedSection().set("projectile-particles.particle", (Object)particle.name());
                inv.getEditedSection().set("projectile-particles.color.red", (Object)red);
                inv.getEditedSection().set("projectile-particles.color.green", (Object)green);
                inv.getEditedSection().set("projectile-particles.color.blue", (Object)blue);
                inv.registerTemplateEdition();
                inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Particle successfully set to " + UtilityMethods.caseOnWords((String)particle.name().toLowerCase().replace("_", " ")) + " with RGB color " + red + " " + green + " " + blue);
            }
        } else {
            Validate.isTrue((msg.length == 1 ? 1 : 0) != 0, (String)"That particle cannot be assigned a color");
            inv.getEditedSection().set("projectile-particles.particle", (Object)particle.name());
            inv.getEditedSection().set("projectile-particles.color.red", (Object)0);
            inv.getEditedSection().set("projectile-particles.color.green", (Object)0);
            inv.getEditedSection().set("projectile-particles.color.blue", (Object)0);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Particle successfully set to " + UtilityMethods.caseOnWords((String)particle.name().toLowerCase().replace("_", " ")));
        }
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull ProjectileParticlesData data) {
        item.addItemTag(this.getAppliedNBT(data));
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull ProjectileParticlesData data) {
        ArrayList<ItemTag> tags = new ArrayList<ItemTag>();
        tags.add(new ItemTag(this.getNBTPath(), (Object)data.toString()));
        return tags;
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoItem) {
        StatData data;
        ArrayList<ItemTag> tags = new ArrayList<ItemTag>();
        if (mmoItem.getNBT().hasTag(this.getNBTPath())) {
            tags.add(ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)mmoItem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.STRING));
        }
        if ((data = this.getLoadedNBT((ArrayList)tags)) != null) {
            mmoItem.setData(this, data);
        }
    }

    @Override
    public ProjectileParticlesData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag tags = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (tags != null) {
            try {
                JsonObject json = new JsonParser().parse((String)tags.getValue()).getAsJsonObject();
                Particle particle = Particle.valueOf((String)json.get("Particle").getAsString());
                if (MMOUtils.isColorable(particle)) {
                    return new ProjectileParticlesData(particle, json.get("Red").getAsInt(), json.get("Green").getAsInt(), json.get("Blue").getAsInt());
                }
                return new ProjectileParticlesData(particle);
            }
            catch (JsonSyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

