/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.gson.JsonArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.StringListData;
import net.Indyuce.mmoitems.stat.type.StringListStat;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;

public class NBTTags
extends StringListStat {
    static String extraneousTag = "EXTMI_";

    public NBTTags() {
        super("CUSTOM_NBT", Material.NAME_TAG, "NBT Tags", new String[]{"Custom NBT Tags."}, new String[0], new Material[0]);
    }

    @Override
    public StringListData whenInitialized(Object object) {
        Validate.isTrue((boolean)(object instanceof List), (String)"Must specify a string list");
        return new StringListData((List)object);
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.PICKUP_ALL) {
            new StatEdition(inv, ItemStats.NBT_TAGS, new Object[0]).enable("Write in the chat the NBT tag you want to add.", ChatColor.AQUA + "Format: {Tag Name} {Tag Value}");
        }
        if (event.getAction() == InventoryAction.PICKUP_HALF && inv.getEditedSection().contains("custom-nbt")) {
            List nbtTags = inv.getEditedSection().getStringList("custom-nbt");
            if (nbtTags.size() < 1) {
                return;
            }
            String last = (String)nbtTags.get(nbtTags.size() - 1);
            nbtTags.remove(last);
            inv.getEditedSection().set("custom-nbt", (Object)nbtTags);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Successfully removed '" + last + "'.");
        }
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        Validate.isTrue((message.split(" ").length > 1 ? 1 : 0) != 0, (String)"Use this format: {Tag Name} {Tag Value}");
        List<String> customNbt = inv.getEditedSection().contains("custom-nbt") ? inv.getEditedSection().getStringList("custom-nbt") : new ArrayList();
        customNbt.add(message);
        inv.getEditedSection().set("custom-nbt", customNbt);
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "StringListStat successfully added.");
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<StringListData> statData) {
        if (statData.isPresent()) {
            lore.add(ChatColor.GRAY + "Current Value:");
            StringListData data = statData.get();
            data.getList().forEach(str -> lore.add(ChatColor.GRAY + str));
        } else {
            lore.add(ChatColor.GRAY + "Current Value: " + ChatColor.RED + "None");
        }
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Click to add a tag.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to remove the last tag.");
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull StringListData data) {
        JsonArray array = new JsonArray();
        ArrayList<ItemTag> ret = new ArrayList<ItemTag>();
        HashMap<String, String> extraneousAdd = new HashMap<String, String>();
        HashMap<String, ItemTag> tagsAdd = new HashMap<String, ItemTag>();
        for (String str : data.getList()) {
            if (str.startsWith(extraneousTag)) continue;
            array.add(str);
            String tagName = str.substring(0, str.indexOf(32));
            String tagValue = str.substring(str.indexOf(32) + 1);
            extraneousAdd.put(tagName, extraneousTag + str);
            tagsAdd.put(tagName, new ItemTag(tagName, this.calculateObjectType(tagValue)));
        }
        for (String extrstr : data.getList()) {
            if (!extrstr.startsWith(extraneousTag)) continue;
            String str = extrstr.substring(extraneousTag.length());
            String tagName = str.substring(0, str.indexOf(32));
            String tagValue = str.substring(str.indexOf(32) + 1);
            if (extraneousAdd.containsKey(tagName)) {
                extraneousAdd.put(tagName, extrstr);
                continue;
            }
            if (tagValue.isEmpty()) {
                tagsAdd.remove(tagName);
            } else {
                tagsAdd.put(tagName, new ItemTag(tagName, this.calculateObjectType(tagValue)));
            }
            extraneousAdd.remove(tagName);
        }
        for (String tagName : tagsAdd.keySet()) {
            ret.add((ItemTag)tagsAdd.get(tagName));
            array.add((String)extraneousAdd.get(tagName));
        }
        ret.add(new ItemTag(this.getNBTPath(), (Object)array.toString()));
        return ret;
    }

    public Object calculateObjectType(String input) {
        if (input.equalsIgnoreCase("true")) {
            return true;
        }
        if (input.equalsIgnoreCase("false")) {
            return false;
        }
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.parseDouble(input);
            }
            catch (NumberFormatException numberFormatException2) {
                if (input.contains("[") && input.contains("]")) {
                    ArrayList<String> entries = new ArrayList<String>();
                    for (String s : input.replace("[", "").replace("]", "").split(",")) {
                        entries.add(s.replace("\"", ""));
                    }
                    return entries;
                }
                return input;
            }
        }
    }
}

