/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.version.Sounds;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.api.player.RPGPlayer;
import net.Indyuce.mmoitems.api.util.NumericStatFormula;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.stat.data.DoubleData;
import net.Indyuce.mmoitems.stat.data.MaterialData;
import net.Indyuce.mmoitems.stat.type.DoubleStat;
import net.Indyuce.mmoitems.stat.type.GemStoneStat;
import net.Indyuce.mmoitems.stat.type.ItemRestriction;
import net.Indyuce.mmoitems.stat.type.Upgradable;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public class MaximumDurability
extends DoubleStat
implements ItemRestriction,
GemStoneStat,
Upgradable {
    public MaximumDurability() {
        super("MAX_DURABILITY", Material.SHEARS, "Maximum Custom Durability", new String[]{"The amount of uses before your", "item becomes unusable/breaks."}, new String[]{"!block", "all"}, new Material[0]);
    }

    @Override
    public void whenPreviewed(@NotNull ItemStackBuilder item, @NotNull DoubleData currentData, @NotNull NumericStatFormula templateData) throws IllegalArgumentException {
        this.whenApplied(item, currentData);
    }

    @Override
    public void loadConfiguration(@NotNull ConfigurationSection legacyLanguageFile, @NotNull Object configObject) {
        this.generalStatFormat = legacyLanguageFile.getString("item-damage");
        if (this.generalStatFormat == null) {
            this.generalStatFormat = legacyLanguageFile.getString("durability");
        }
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull DoubleData data) {
        int max = (int)data.getValue();
        int current = item.getMMOItem().hasData(ItemStats.CUSTOM_DURABILITY) ? (int)((DoubleData)item.getMMOItem().getData(ItemStats.CUSTOM_DURABILITY)).getValue() : max;
        item.addItemTag(new ItemTag(this.getNBTPath(), (Object)max));
        String format = this.getGeneralStatFormat().replace("{max}", String.valueOf(max)).replace("{current}", String.valueOf(current));
        item.getLore().insert("durability", format);
    }

    @Override
    public void preprocess(@NotNull MMOItem item) {
        if (!item.hasData(ItemStats.MAX_DURABILITY)) {
            int base = 400;
            if (item.hasData(ItemStats.MATERIAL)) {
                MaterialData data = (MaterialData)item.getData(ItemStats.MATERIAL);
                Material mat = data.getMaterial();
                base = mat.getMaxDurability();
            }
            if (base < 8) {
                base = 400;
            }
            item.setData(ItemStats.MAX_DURABILITY, new DoubleData(base));
        }
    }

    @Override
    public boolean canUse(RPGPlayer player, NBTItem item, boolean message) {
        if (!item.hasTag("MMOITEMS_DURABILITY")) {
            return true;
        }
        if (item.getDouble(ItemStats.CUSTOM_DURABILITY.getNBTPath()) <= 0.0) {
            if (message) {
                Message.ZERO_DURABILITY.format(ChatColor.RED, new String[0]).send(player.getPlayer());
                player.getPlayer().playSound(player.getPlayer().getLocation(), Sounds.ENTITY_VILLAGER_NO, 1.0f, 1.5f);
            }
            return false;
        }
        return true;
    }
}

