/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import java.util.ArrayList;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.api.util.NumericStatFormula;
import net.Indyuce.mmoitems.stat.annotation.VersionDependant;
import net.Indyuce.mmoitems.stat.data.DoubleData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.DoubleStat;
import net.Indyuce.mmoitems.stat.type.GemStoneStat;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.inventory.meta.Damageable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@VersionDependant(version={1, 20, 5})
public class MaxItemDamage
extends DoubleStat
implements GemStoneStat {
    public MaxItemDamage() {
        super("MAX_ITEM_DAMAGE", Material.DAMAGED_ANVIL, "Maximum Vanilla Durability", new String[]{"Only available in 1.20.5+", "Maximum amount of durability on your item.", "This works using vanilla durability and is", "much more stable than Custom Durability."}, new String[]{"all"}, new Material[0]);
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull DoubleData data) {
        Validate.isTrue((boolean)(item.getMeta() instanceof Damageable), (String)"Item is not damageable");
        int value = (int)data.getValue();
        Validate.isTrue((value > 0 ? 1 : 0) != 0, (String)"Maximum durability must be positive");
        ((Damageable)item.getMeta()).setMaxDamage(Integer.valueOf((int)data.getValue()));
        item.addItemTag(this.getAppliedNBT(data));
    }

    @Override
    public void whenPreviewed(@NotNull ItemStackBuilder item, @NotNull DoubleData currentData, @NotNull NumericStatFormula templateData) throws IllegalArgumentException {
        this.whenApplied(item, currentData);
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull DoubleData data) {
        ArrayList<ItemTag> ret = new ArrayList<ItemTag>();
        ret.add(new ItemTag(this.getNBTPath(), (Object)((int)data.getValue())));
        return ret;
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        StatData data;
        ArrayList<ItemTag> relevantTags = new ArrayList<ItemTag>();
        if (mmoitem.getNBT().hasTag(this.getNBTPath())) {
            relevantTags.add(ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.INTEGER));
        }
        if ((data = this.getLoadedNBT((ArrayList)relevantTags)) != null) {
            mmoitem.setData(this, data);
        }
    }

    @Override
    @Nullable
    public DoubleData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag cmd = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (cmd != null) {
            return new DoubleData(((Integer)cmd.getValue()).intValue());
        }
        return null;
    }
}

