/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.api.item.NBTItem;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.api.item.mmoitem.VolatileMMOItem;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.player.RPGPlayer;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.stat.data.DoubleData;
import net.Indyuce.mmoitems.stat.type.DoubleStat;
import net.Indyuce.mmoitems.stat.type.ItemRestriction;
import net.Indyuce.mmoitems.stat.type.PlayerConsumable;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ManaCost
extends DoubleStat
implements ItemRestriction,
PlayerConsumable {
    public ManaCost() {
        super("MANA_COST", Material.LAPIS_LAZULI, "Mana Cost", new String[]{"Mana spent by your weapon to be used."}, new String[]{"weapon"}, new Material[0]);
    }

    @Override
    public boolean canUse(RPGPlayer player, NBTItem item, boolean message) {
        boolean hasMana;
        if (!item.hasTag(ItemStats.MANA_COST.getNBTPath())) {
            return true;
        }
        double manaCost = item.getDouble(ItemStats.MANA_COST.getNBTPath());
        boolean bl = hasMana = manaCost > 0.0 && player.getMana() >= manaCost;
        if (!hasMana) {
            Message.NOT_ENOUGH_MANA.format(ChatColor.RED, new String[0]).send(player.getPlayer());
        }
        return hasMana;
    }

    @Override
    public void onConsume(@NotNull VolatileMMOItem mmo, @NotNull Player player, boolean vanillaEating) {
        if (!mmo.hasData(ItemStats.MANA_COST)) {
            return;
        }
        DoubleData d = (DoubleData)mmo.getData(ItemStats.MANA_COST);
        if (d.getValue() > 0.0) {
            RPGPlayer rpgPlayer = PlayerData.get((OfflinePlayer)player).getRPG();
            rpgPlayer.setMana(rpgPlayer.getMana() - d.getValue());
        }
    }
}

