/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.MythicLib;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.StringListData;
import net.Indyuce.mmoitems.stat.type.GemStoneStat;
import net.Indyuce.mmoitems.stat.type.StringListStat;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;

public class GrantedPermissions
extends StringListStat
implements GemStoneStat {
    public GrantedPermissions() {
        super("GRANTED_PERMISSIONS", Material.NAME_TAG, "Granted Permissions", new String[]{"A list of permissions that will,", "be granted by the item."}, new String[0], new Material[0]);
    }

    @Override
    public StringListData whenInitialized(Object object) {
        Validate.isTrue((boolean)(object instanceof List), (String)"Must specify a string list");
        return new StringListData((List)object);
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.PICKUP_ALL) {
            new StatEdition(inv, ItemStats.GRANTED_PERMISSIONS, new Object[0]).enable("Write in the chat the permission you want to add.");
        }
        if (event.getAction() == InventoryAction.PICKUP_HALF && inv.getEditedSection().contains(this.getPath())) {
            List permissions = inv.getEditedSection().getStringList(this.getPath());
            if (permissions.isEmpty()) {
                return;
            }
            String last = (String)permissions.get(permissions.size() - 1);
            permissions.remove(last);
            inv.getEditedSection().set(this.getPath(), (Object)(permissions.isEmpty() ? null : permissions));
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Successfully removed '" + MythicLib.plugin.parseColors(last) + ChatColor.GRAY + "'.");
        }
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        ArrayList<String> permissions = inv.getEditedSection().contains(this.getPath()) ? inv.getEditedSection().getStringList(this.getPath()) : new ArrayList<String>();
        permissions.add(message);
        inv.getEditedSection().set(this.getPath(), permissions);
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Permission successfully added.");
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<StringListData> statData) {
        if (statData.isPresent()) {
            lore.add(ChatColor.GRAY + "Current Value:");
            StringListData data = statData.get();
            data.getList().forEach(element -> lore.add(ChatColor.GRAY + element));
        } else {
            lore.add(ChatColor.GRAY + "Current Value: " + ChatColor.RED + "None");
        }
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Click to add a permission.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to remove the last permission.");
    }
}

