/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackCategory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackMessage;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackPalette;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.api.util.ui.PlusMinusPercent;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.api.util.NumericStatFormula;
import net.Indyuce.mmoitems.api.util.message.FFPMMOItems;
import net.Indyuce.mmoitems.comp.enchants.EnchantPlugin;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.EnchantListData;
import net.Indyuce.mmoitems.stat.data.random.RandomEnchantListData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.data.type.UpgradeInfo;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.stat.type.StatHistory;
import net.Indyuce.mmoitems.stat.type.Upgradable;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Enchants
extends ItemStat<RandomEnchantListData, EnchantListData>
implements Upgradable {
    public Enchants() {
        super("ENCHANTS", Material.ENCHANTED_BOOK, "Enchantments", new String[]{"The item enchants."}, new String[0], new Material[0]);
    }

    @Override
    public RandomEnchantListData whenInitialized(Object object) {
        Validate.isTrue((boolean)(object instanceof ConfigurationSection), (String)"Must specify a config section");
        return new RandomEnchantListData((ConfigurationSection)object);
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.PICKUP_ALL) {
            new StatEdition(inv, ItemStats.ENCHANTS, new Object[0]).enable("Write in the chat the enchant you want to add.", ChatColor.AQUA + "Format: {Enchant Name} {Enchant Level Numeric Formula}");
        }
        if (event.getAction() == InventoryAction.PICKUP_HALF && inv.getEditedSection().contains("enchants")) {
            Set set = inv.getEditedSection().getConfigurationSection("enchants").getKeys(false);
            String last = Arrays.asList(set.toArray(new String[0])).get(set.size() - 1);
            inv.getEditedSection().set("enchants." + last, null);
            if (set.size() <= 1) {
                inv.getEditedSection().set("enchants", null);
            }
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Successfully removed " + last.substring(0, 1).toUpperCase() + last.substring(1).toLowerCase().replace("_", " ") + ".");
        }
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        String[] split = message.split(" ");
        Enchantment enchant = Enchants.getEnchant(split[0]);
        Validate.notNull((Object)enchant, (String)(split[0] + " is not a valid enchantment! All enchants can be found here: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/enchantments/Enchantment.html"));
        NumericStatFormula formula = split.length > 1 ? new NumericStatFormula(message.substring(message.indexOf(" ") + 1)) : new NumericStatFormula(1.0, 0.0, 0.0, 0.0);
        formula.fillConfigurationSection(inv.getEditedSection(), "enchants." + enchant.getKey().getKey());
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + enchant.getKey().getKey() + " " + formula + " successfully added.");
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<RandomEnchantListData> statData) {
        if (statData.isPresent()) {
            lore.add(ChatColor.GRAY + "Current Value:");
            RandomEnchantListData data = statData.get();
            data.getEnchants().forEach(enchant -> lore.add(ChatColor.GRAY + "* " + UtilityMethods.caseOnWords((String)enchant.getKey().getKey().replace("_", " ")) + " " + data.getLevel((Enchantment)enchant).toString()));
        } else {
            lore.add(ChatColor.GRAY + "Current Value: " + ChatColor.RED + "None");
        }
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Click to add an enchant.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to remove the last enchant.");
    }

    @Override
    @NotNull
    public EnchantListData getClearStatData() {
        return new EnchantListData();
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        ItemMeta itemMeta;
        EnchantListData enchants = new EnchantListData();
        ItemStack item = mmoitem.getNBT().getItem();
        if (item.hasItemMeta() && (itemMeta = item.getItemMeta()) != null) {
            for (Enchantment enchant : itemMeta.getEnchants().keySet()) {
                enchants.addEnchant(enchant, itemMeta.getEnchantLevel(enchant));
            }
            if (itemMeta instanceof EnchantmentStorageMeta) {
                for (Enchantment enchant : ((EnchantmentStorageMeta)itemMeta).getStoredEnchants().keySet()) {
                    enchants.addEnchant(enchant, ((EnchantmentStorageMeta)itemMeta).getStoredEnchantLevel(enchant));
                }
            }
        }
        mmoitem.setData(ItemStats.ENCHANTS, enchants);
        ItemTag hisTag = ItemTag.getTagAtPath((String)("HSTRY_" + this.getId()), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.STRING);
        if (!(hisTag != null || mmoitem.getNBT().getBoolean(ItemStats.DISABLE_ENCHANTING.getNBTPath()) && mmoitem.getNBT().getBoolean(ItemStats.DISABLE_REPAIRING.getNBTPath()))) {
            mmoitem.computeStatHistory(ItemStats.ENCHANTS);
        }
    }

    @NotNull
    public static EnchantListData fromVanilla(@Nullable ItemStack source) {
        EnchantListData eld = new EnchantListData();
        if (source == null) {
            return eld;
        }
        for (Enchantment e : source.getEnchantments().keySet()) {
            int l = source.getEnchantmentLevel(e);
            if (l == 0) continue;
            eld.addEnchant(e, l);
        }
        return eld;
    }

    @Override
    @Nullable
    public EnchantListData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag enchantTag = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (enchantTag != null) {
            ArrayList enchants = ItemTag.getStringListFromTag((ItemTag)enchantTag);
            EnchantListData data = new EnchantListData();
            for (String str : enchants) {
                String[] split = str.split(" ");
                if (split.length < 2) continue;
                String enchantment = split[0];
                String level = split[1];
                Enchantment ench = null;
                try {
                    ench = Enchants.getEnchant(enchantment);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Integer lvl = SilentNumbers.IntegerParse((String)level);
                if (ench == null || lvl == null) continue;
                data.addEnchant(ench, lvl);
            }
            return data;
        }
        return null;
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull EnchantListData enchants) {
        block0: for (Enchantment enchant : enchants.getEnchants()) {
            int lvl = enchants.getLevel(enchant);
            if (item.getItemStack().getType() == Material.ENCHANTED_BOOK) {
                ((EnchantmentStorageMeta)item.getMeta()).addStoredEnchant(enchant, lvl, true);
            } else {
                item.getMeta().addEnchant(enchant, lvl, true);
            }
            for (EnchantPlugin<?> enchantPlugin : MMOItems.plugin.getEnchantPlugins()) {
                Object custom = enchantPlugin.transfer(enchant);
                if (custom == null) continue;
                enchantPlugin.handleEnchant(item, custom, lvl);
                continue block0;
            }
        }
        item.addItemTag(this.getAppliedNBT(enchants));
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull EnchantListData data) {
        ArrayList<ItemTag> ret = new ArrayList<ItemTag>();
        ArrayList<String> enchantments = new ArrayList<String>();
        for (Enchantment enchantment : data.getEnchants()) {
            enchantments.add(enchantment.getKey().getKey() + " " + data.getLevel(enchantment));
        }
        ret.add(ItemTag.fromStringList((String)this.getNBTPath(), enchantments));
        return ret;
    }

    @Override
    @NotNull
    public UpgradeInfo loadUpgradeInfo(@Nullable Object obj) throws IllegalArgumentException {
        return EnchantUpgradeInfo.GetFrom(obj);
    }

    @Override
    @NotNull
    public StatData apply(@NotNull StatData original, @NotNull UpgradeInfo info, int level) {
        if (original instanceof EnchantListData && info instanceof EnchantUpgradeInfo) {
            EnchantListData dataEnchants = (EnchantListData)original;
            EnchantUpgradeInfo eui = (EnchantUpgradeInfo)info;
            for (Enchantment e : eui.getAffectedEnchantments()) {
                int lSimulation;
                double value = dataEnchants.getLevel(e);
                PlusMinusPercent pmp = eui.getPMP(e);
                if (pmp == null) continue;
                if (lSimulation > 0) {
                    for (lSimulation = level; lSimulation > 0; --lSimulation) {
                        value = pmp.apply(value);
                    }
                } else if (lSimulation < 0) {
                    while (lSimulation < 0) {
                        value = pmp.reverse(value);
                        ++lSimulation;
                    }
                }
                dataEnchants.addEnchant(e, SilentNumbers.floor((double)value));
            }
            return dataEnchants;
        }
        return original;
    }

    public static void separateEnchantments(@NotNull MMOItem mmoitem) {
        if (mmoitem.hasData(ItemStats.DISABLE_REPAIRING) && mmoitem.hasData(ItemStats.DISABLE_ENCHANTING)) {
            return;
        }
        boolean additiveMerge = MMOItems.plugin.getConfig().getBoolean("stat-merging.additive-enchantments", false);
        if (mmoitem.hasData(ItemStats.ENCHANTS)) {
            EnchantListData data = (EnchantListData)mmoitem.getData(ItemStats.ENCHANTS);
            StatHistory hist = mmoitem.computeStatHistory(ItemStats.ENCHANTS);
            EnchantListData expected = (EnchantListData)hist.recalculate(mmoitem.getUpgradeLevel());
            HashMap<Enchantment, Integer> discrepancies = new HashMap<Enchantment, Integer>();
            for (Enchantment e : Enchantment.values()) {
                int actual = data.getLevel(e);
                int ideal = expected.getLevel(e);
                if (additiveMerge) {
                    int offset = actual - ideal;
                    if (offset == 0) continue;
                    discrepancies.put(e, offset);
                    continue;
                }
                if (actual <= ideal) continue;
                discrepancies.put(e, actual);
            }
            if (discrepancies.size() > 0) {
                EnchantListData extraneous = new EnchantListData();
                for (Enchantment e : discrepancies.keySet()) {
                    extraneous.addEnchant(e, (Integer)discrepancies.get(e));
                }
                hist.registerExternalData(extraneous);
            }
        }
    }

    @Nullable
    public static Enchantment getEnchant(String key) {
        Enchantment enchant = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)(key = key.toLowerCase().replace("-", "_"))));
        if (enchant != null) {
            return enchant;
        }
        for (EnchantPlugin<?> enchPlugin : MMOItems.plugin.getEnchantPlugins()) {
            enchant = Enchantment.getByKey((NamespacedKey)enchPlugin.getNamespacedKey(key));
            if (enchant == null) continue;
            return enchant;
        }
        return Enchantment.getByName((String)key);
    }

    public static class EnchantUpgradeInfo
    implements UpgradeInfo {
        @NotNull
        HashMap<Enchantment, PlusMinusPercent> perEnchantmentOperations = new HashMap();

        @NotNull
        public static EnchantUpgradeInfo GetFrom(@Nullable Object obj) throws IllegalArgumentException {
            Validate.notNull((Object)obj, (String)FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Upgrade operation list must not be null", (String[])new String[0]));
            if (!(obj instanceof List)) {
                throw new IllegalArgumentException(FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Expected a list of strings instead of $i{0}", (String[])new String[]{obj.toString()}));
            }
            ArrayList<String> strlst = new ArrayList<String>();
            boolean failure = false;
            StringBuilder unreadableStatements = new StringBuilder();
            for (Object entry : (List)obj) {
                if (entry instanceof String) {
                    strlst.add((String)entry);
                    continue;
                }
                failure = true;
                unreadableStatements.append(FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)" Invalid list entry $i{0}$b;", (String[])new String[]{obj.toString()}));
            }
            if (failure) {
                throw new IllegalArgumentException(FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Could not read enchantment list:", (String[])new String[0]) + unreadableStatements.toString());
            }
            if (strlst.isEmpty()) {
                throw new IllegalArgumentException(FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Upgrade operation list is empty", (String[])new String[0]));
            }
            EnchantUpgradeInfo eui = new EnchantUpgradeInfo();
            for (String str : strlst) {
                String[] split = str.split(" ");
                if (split.length >= 2) {
                    String enchStr = split[0];
                    String pmpStr = split[1];
                    char c = pmpStr.charAt(0);
                    if (c == 's') {
                        pmpStr = pmpStr.substring(1);
                    } else if (c != '+' && c != '-' && c != 'n') {
                        pmpStr = '+' + pmpStr;
                    }
                    FriendlyFeedbackProvider ffp = new FriendlyFeedbackProvider((FriendlyFeedbackPalette)FFPMMOItems.get());
                    PlusMinusPercent pmpRead = PlusMinusPercent.getFromString((String)pmpStr, (FriendlyFeedbackProvider)ffp);
                    Enchantment ench = null;
                    try {
                        ench = Enchants.getEnchant(enchStr);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (pmpRead == null) {
                        unreadableStatements.append(' ').append(((FriendlyFeedbackMessage)ffp.getFeedbackOf(FriendlyFeedbackCategory.ERROR).get(0)).forConsole(ffp.getPalette()));
                        failure = true;
                    }
                    if (ench == null) {
                        unreadableStatements.append(FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)" Invalid Enchantment $i{0}$b.", (String[])new String[]{enchStr}));
                        failure = true;
                    }
                    if (pmpRead == null || ench == null) continue;
                    eui.addEnchantmentOperation(ench, pmpRead);
                    continue;
                }
                failure = true;
                unreadableStatements.append(FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)" Invalid list entry $i{0}$b. List entries are of the format 'esharpness +1$b'.", (String[])new String[]{str}));
            }
            if (failure) {
                throw new IllegalArgumentException(FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Could not read enchantment list:", (String[])new String[0]) + unreadableStatements.toString());
            }
            return eui;
        }

        @Nullable
        public PlusMinusPercent getPMP(@NotNull Enchantment ench) {
            return this.perEnchantmentOperations.get(ench);
        }

        public void addEnchantmentOperation(@NotNull Enchantment e, @NotNull PlusMinusPercent op) {
            this.perEnchantmentOperations.put(e, op);
        }

        @NotNull
        public Set<Enchantment> getAffectedEnchantments() {
            return this.perEnchantmentOperations.keySet();
        }
    }
}

