/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import io.lumine.mythic.lib.element.Element;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.api.util.NumericStatFormula;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.gui.edition.ElementsEdition;
import net.Indyuce.mmoitems.stat.data.ElementListData;
import net.Indyuce.mmoitems.stat.data.random.RandomElementListData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.DoubleStat;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.stat.type.Previewable;
import net.Indyuce.mmoitems.util.ElementStatType;
import net.Indyuce.mmoitems.util.Pair;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Elements
extends ItemStat<RandomElementListData, ElementListData>
implements Previewable<RandomElementListData, ElementListData> {
    private Map<ElementStatType, String> statFormat = new HashMap<ElementStatType, String>();

    public Elements() {
        super("ELEMENT", Material.SLIME_BALL, "Elements", new String[]{"The elements of your item."}, new String[]{"equipment", "ornament", "gem_stone"}, new Material[0]);
    }

    @Override
    public RandomElementListData whenInitialized(Object object) {
        Validate.isTrue((boolean)(object instanceof ConfigurationSection), (String)"Must specify a config section");
        return new RandomElementListData((ConfigurationSection)object);
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.PICKUP_ALL) {
            new ElementsEdition(inv.getPlayer(), inv.getEdited()).open(inv);
        }
        if (event.getAction() == InventoryAction.PICKUP_HALF && inv.getEditedSection().contains("element")) {
            inv.getEditedSection().set("element", null);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Elements successfully removed.");
        }
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        String elementPath = info[0].toString();
        NumericStatFormula formula = new NumericStatFormula(message);
        formula.fillConfigurationSection(inv.getEditedSection(), "element." + elementPath);
        String elementName = elementPath.split("\\.")[0];
        if (inv.getEditedSection().contains("element")) {
            if (inv.getEditedSection().getConfigurationSection("element").contains(elementName) && inv.getEditedSection().getConfigurationSection("element." + elementName).getKeys(false).isEmpty()) {
                inv.getEditedSection().set("element." + elementName, null);
            }
            if (inv.getEditedSection().getConfigurationSection("element").getKeys(false).isEmpty()) {
                inv.getEditedSection().set("element", null);
            }
        }
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + ChatColor.RED + UtilityMethods.caseOnWords((String)elementPath.replace(".", " ")) + ChatColor.GRAY + " successfully changed to " + ChatColor.GOLD + formula + ChatColor.GRAY + ".");
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<RandomElementListData> statData) {
        if (statData.isPresent()) {
            lore.add(ChatColor.GRAY + "Current Value:");
            RandomElementListData data = statData.get();
            data.getKeys().forEach(key -> lore.add(ChatColor.GRAY + "* " + ((Element)key.getKey()).getName() + " " + ((ElementStatType)((Object)((Object)key.getValue()))).getName() + ": " + ChatColor.RED + data.getStat((Element)key.getKey(), (ElementStatType)((Object)((Object)key.getValue())))));
        } else {
            lore.add(ChatColor.GRAY + "Current Value: " + ChatColor.RED + "None");
        }
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Click to access the elements edition menu.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to remove all the elements.");
    }

    @Override
    @NotNull
    public ElementListData getClearStatData() {
        return new ElementListData();
    }

    @Override
    public void loadConfiguration(@NotNull ConfigurationSection legacyLanguageFile, @NotNull Object configObject) {
        if (configObject instanceof String) {
            for (ElementStatType statType : ElementStatType.values()) {
                this.statFormat.put(statType, legacyLanguageFile.getString("elemental-" + statType.lowerCaseName(), "<TranslationNotFound:" + statType.name().toLowerCase() + ">"));
            }
        } else {
            Validate.isTrue((boolean)(configObject instanceof ConfigurationSection), (String)"Must be a config section");
            ConfigurationSection config = (ConfigurationSection)configObject;
            for (ElementStatType statType : ElementStatType.values()) {
                this.statFormat.put(statType, config.getString(statType.lowerCaseName(), "<TranslationNotFound:" + statType.lowerCaseName() + ">"));
            }
        }
    }

    @Override
    public String getLegacyTranslationPath() {
        return "elemental-damage";
    }

    @NotNull
    private String formatForLore(Element element, ElementStatType statType) {
        return this.statFormat.get((Object)statType).replace("{color}", element.getColor()).replace("{icon}", element.getLoreIcon()).replace("{element}", element.getName());
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull ElementListData data) {
        ArrayList<String> lore = new ArrayList<String>();
        for (Pair<Element, ElementStatType> pair : data.getKeys()) {
            String format = this.formatForLore(pair.getKey(), pair.getValue());
            double value = data.getStat(pair.getKey(), pair.getValue());
            lore.add(DoubleStat.formatPath("ELEMENTAL_STAT", format, true, value));
        }
        if (!lore.isEmpty()) {
            item.getLore().insert("elements", lore);
        }
        item.addItemTag(this.getAppliedNBT(data));
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull ElementListData data) {
        ArrayList<ItemTag> ret = new ArrayList<ItemTag>();
        for (Pair<Element, ElementStatType> pair : data.getKeys()) {
            ret.add(new ItemTag("MMOITEMS_" + pair.getValue().getConcatenatedTagPath(pair.getKey()), (Object)data.getStat(pair.getKey(), pair.getValue())));
        }
        return ret;
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        ArrayList<ItemTag> relevantTags = new ArrayList<ItemTag>();
        for (Element element : Element.values()) {
            for (ElementStatType statType : ElementStatType.values()) {
                String path = "MMOITEMS_" + statType.getConcatenatedTagPath(element);
                if (!mmoitem.getNBT().hasTag(path)) continue;
                relevantTags.add(ItemTag.getTagAtPath((String)path, (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.DOUBLE));
            }
        }
        StatData data = this.getLoadedNBT((ArrayList)relevantTags);
        if (data != null) {
            mmoitem.setData(this, data);
        }
    }

    @Override
    @Nullable
    public ElementListData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ElementListData elements = new ElementListData();
        for (Element element : Element.values()) {
            for (ElementStatType statType : ElementStatType.values()) {
                String path = "MMOITEMS_" + statType.getConcatenatedTagPath(element);
                ItemTag tag = ItemTag.getTagAtPath((String)path, storedTags);
                if (tag == null) continue;
                elements.setStat(element, statType, (Double)tag.getValue());
            }
        }
        return elements.isEmpty() ? null : elements;
    }

    @Override
    public void whenPreviewed(@NotNull ItemStackBuilder item, @NotNull ElementListData currentData, @NotNull RandomElementListData templateData) throws IllegalArgumentException {
        Validate.isTrue((boolean)(currentData instanceof ElementListData), (String)"Current Data is not ElementListData");
        Validate.isTrue((boolean)(templateData instanceof RandomElementListData), (String)"Template Data is not RandomElementListData");
        ArrayList<String> elementLore = new ArrayList<String>();
        for (Element element : Element.values()) {
            for (ElementStatType statType : ElementStatType.values()) {
                NumericStatFormula nsf = templateData.getStat(element, statType);
                double techMinimum = nsf.calculate(0.0, NumericStatFormula.FormulaInputType.LOWER_BOUND);
                double techMaximum = nsf.calculate(0.0, NumericStatFormula.FormulaInputType.UPPER_BOUND);
                if (techMinimum == 0.0 && techMaximum == 0.0) continue;
                String builtRange = DoubleStat.formatPath(statType.getConcatenatedTagPath(element), this.formatForLore(element, statType), true, techMinimum, techMaximum);
                elementLore.add(builtRange);
            }
        }
        if (!elementLore.isEmpty()) {
            item.getLore().insert("elements", elementLore);
        }
        item.addItemTag(this.getAppliedNBT(currentData));
    }
}

