/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackPalette;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.gson.JsonArray;
import io.lumine.mythic.lib.gson.JsonElement;
import io.lumine.mythic.lib.gson.JsonObject;
import io.lumine.mythic.lib.gson.JsonParser;
import io.lumine.mythic.lib.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.api.item.mmoitem.VolatileMMOItem;
import net.Indyuce.mmoitems.api.util.NumericStatFormula;
import net.Indyuce.mmoitems.api.util.message.FFPMMOItems;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.PotionEffectData;
import net.Indyuce.mmoitems.stat.data.PotionEffectListData;
import net.Indyuce.mmoitems.stat.data.random.RandomPotionEffectData;
import net.Indyuce.mmoitems.stat.data.random.RandomPotionEffectListData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.stat.type.PlayerConsumable;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Effects
extends ItemStat<RandomPotionEffectListData, PotionEffectListData>
implements PlayerConsumable {
    public Effects() {
        super("EFFECTS", Material.POTION, "Effects", new String[]{"The potion effects your", "consumable item grants."}, new String[]{"consumable"}, new Material[0]);
    }

    @Override
    public RandomPotionEffectListData whenInitialized(Object object) {
        Validate.isTrue((boolean)(object instanceof ConfigurationSection), (String)"Must specify a config section");
        return new RandomPotionEffectListData((ConfigurationSection)object);
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.PICKUP_ALL) {
            new StatEdition(inv, ItemStats.EFFECTS, new Object[0]).enable("Write in the chat the permanent potion effect you want to add.", ChatColor.AQUA + "Format: {Potion Effect Name}|{Duration Numeric Formula}|{Amplifier Numeric Formula}", ChatColor.DARK_RED + "Note: " + ChatColor.RED + "The '|' lines are literal.");
        }
        if (event.getAction() == InventoryAction.PICKUP_HALF && inv.getEditedSection().contains("effects")) {
            Set set = inv.getEditedSection().getConfigurationSection("effects").getKeys(false);
            String last = Arrays.asList(set.toArray(new String[0])).get(set.size() - 1);
            inv.getEditedSection().set("effects." + last, null);
            if (set.size() <= 1) {
                inv.getEditedSection().set("effects", null);
            }
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Successfully removed " + last.substring(0, 1).toUpperCase() + last.substring(1).toLowerCase() + ChatColor.GRAY + ".");
        }
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        String[] split = message.split("\\|");
        Validate.isTrue((split.length > 1 ? 1 : 0) != 0, (String)FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Use this format: $e{Potion Effect Name}|{Duration Numeric Formula}|{Amplifier Numeric Formula}$b.", (String[])new String[0]));
        PotionEffectType effect = PotionEffectType.getByName((String)split[0].replace("-", "_").replace(" ", "_").toUpperCase());
        Validate.notNull((Object)effect, (String)(split[0] + FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)" is not a valid potion effect. All potion effects can be found here:$e https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/potion/PotionEffectType.html", (String[])new String[0])));
        NumericStatFormula duration = new NumericStatFormula(split[1]);
        NumericStatFormula amplifier = split.length > 2 ? new NumericStatFormula(split[2]) : new NumericStatFormula(1.0, 0.0, 0.0, 0.0);
        duration.fillConfigurationSection(inv.getEditedSection(), "effects." + effect.getName() + ".duration");
        amplifier.fillConfigurationSection(inv.getEditedSection(), "effects." + effect.getName() + ".amplifier");
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + effect.getName() + " " + amplifier + " successfully added.");
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<RandomPotionEffectListData> statData) {
        statData.ifPresentOrElse(randomPotionEffectListData -> {
            lore.add(ChatColor.GRAY + "Current Value:");
            for (RandomPotionEffectData effect : randomPotionEffectListData.getEffects()) {
                lore.add(ChatColor.GRAY + "* " + ChatColor.GREEN + UtilityMethods.caseOnWords((String)effect.getType().getName().toLowerCase().replace("_", " ")) + ChatColor.GRAY + " Level: " + ChatColor.GREEN + effect.getAmplifier() + ChatColor.GRAY + " Duration: " + ChatColor.GREEN + effect.getDuration());
            }
        }, () -> lore.add(ChatColor.GRAY + "Current Value: " + ChatColor.RED + "None"));
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Click to add an effect.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to remove the last effect.");
    }

    @Override
    @NotNull
    public PotionEffectListData getClearStatData() {
        return new PotionEffectListData(new PotionEffectData[0]);
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull PotionEffectListData data) {
        ArrayList<String> lore = new ArrayList<String>();
        String effectFormat = this.getGeneralStatFormat();
        data.getEffects().forEach(effect -> lore.add(effectFormat.replace("{effect}", MMOItems.plugin.getLanguage().getPotionEffectName(effect.getType()) + (effect.getLevel() < 2 ? "" : " " + MMOUtils.intToRoman(effect.getLevel()))).replace("{duration}", MythicLib.plugin.getMMOConfig().decimal.format(effect.getDuration()))));
        item.getLore().insert("effects", lore);
        item.addItemTag(this.getAppliedNBT(data));
    }

    @Override
    public String getLegacyTranslationPath() {
        return "effect";
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull PotionEffectListData data) {
        JsonArray array = new JsonArray();
        for (PotionEffectData effect : data.getEffects()) {
            JsonObject object = new JsonObject();
            object.addProperty("Type", effect.getType().getName());
            object.addProperty("Duration", (Number)effect.getDuration());
            object.addProperty("Level", (Number)effect.getLevel());
            array.add((JsonElement)object);
        }
        ArrayList<ItemTag> ret = new ArrayList<ItemTag>();
        ret.add(new ItemTag(this.getNBTPath(), (Object)array.toString()));
        return ret;
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        StatData data;
        ArrayList<ItemTag> relevantTags = new ArrayList<ItemTag>();
        if (mmoitem.getNBT().hasTag(this.getNBTPath())) {
            relevantTags.add(ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.STRING));
        }
        if ((data = this.getLoadedNBT((ArrayList)relevantTags)) != null) {
            mmoitem.setData(this, data);
        }
    }

    @Override
    @Nullable
    public PotionEffectListData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag rTag = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (rTag == null) {
            return null;
        }
        try {
            PotionEffectListData effects = new PotionEffectListData(new PotionEffectData[0]);
            JsonArray array = new JsonParser().parse((String)rTag.getValue()).getAsJsonArray();
            for (JsonElement e : array) {
                if (!e.isJsonObject()) continue;
                JsonObject key = e.getAsJsonObject();
                effects.add(new PotionEffectData(PotionEffectType.getByName((String)key.get("Type").getAsString()), key.get("Duration").getAsDouble(), key.get("Level").getAsInt()));
            }
            return effects;
        }
        catch (JsonSyntaxException | IllegalStateException throwable) {
            return null;
        }
    }

    @Override
    public void onConsume(@NotNull VolatileMMOItem mmo, @NotNull Player player, boolean vanillaEating) {
        if (!mmo.hasData(ItemStats.EFFECTS)) {
            return;
        }
        PotionEffectListData pelData = (PotionEffectListData)mmo.getData(ItemStats.EFFECTS);
        for (PotionEffectData ped : pelData.getEffects()) {
            if (ped == null) continue;
            player.removePotionEffect(ped.getType());
            player.addPotionEffect(ped.toEffect());
        }
    }
}

