/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.api.item.ItemTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.ColorData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DyeColor
extends ItemStat<ColorData, ColorData> {
    public DyeColor() {
        super("DYE_COLOR", Material.RED_DYE, "Dye Color", new String[]{"The color of your item", "(for dyeable items).", "In RGB."}, new String[0], Material.LEATHER_HELMET, Material.LEATHER_CHESTPLATE, Material.LEATHER_LEGGINGS, Material.LEATHER_BOOTS, Material.LEATHER_HORSE_ARMOR);
    }

    @Override
    public ColorData whenInitialized(Object object) {
        Validate.isTrue((boolean)(object instanceof String), (String)"Must specify a string");
        return new ColorData((String)object);
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.PICKUP_ALL) {
            new StatEdition(inv, ItemStats.DYE_COLOR, new Object[0]).enable("Write in the chat the RGB color you want.", ChatColor.AQUA + "Format: {Red} {Green} {Blue}");
        }
        if (event.getAction() == InventoryAction.PICKUP_HALF) {
            inv.getEditedSection().set("dye-color", null);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Successfully removed Dye Color.");
        }
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        String[] split = message.split(" ");
        Validate.isTrue((split.length == 3 ? 1 : 0) != 0, (String)"Use this format: {Red} {Green} {Blue}.");
        for (String str : split) {
            int k = Integer.parseInt(str);
            Validate.isTrue((k >= 0 && k < 256 ? 1 : 0) != 0, (String)"Color must be between 0 and 255");
        }
        inv.getEditedSection().set("dye-color", (Object)message);
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Dye Color successfully changed to " + message + ".");
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<ColorData> statData) {
        lore.add(ChatColor.GRAY + "Current Value: " + (statData.isPresent() ? ChatColor.GREEN + statData.get().toString() : ChatColor.RED + "None"));
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Click to change this value.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to remove the dye color.");
    }

    @Override
    @NotNull
    public ColorData getClearStatData() {
        return new ColorData(0, 0, 0);
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        ItemMeta iMeta = mmoitem.getNBT().getItem().getItemMeta();
        if (iMeta instanceof LeatherArmorMeta) {
            ArrayList<ItemTag> relevantTags = new ArrayList<ItemTag>();
            relevantTags.add(new ItemTag(this.getNBTPath(), (Object)((LeatherArmorMeta)iMeta).getColor()));
            StatData data = this.getLoadedNBT((ArrayList)relevantTags);
            if (data != null) {
                mmoitem.setData(this, data);
            }
        }
    }

    @Override
    @Nullable
    public ColorData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag dyedColour = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (dyedColour != null) {
            Color c = (Color)dyedColour.getValue();
            return new ColorData(c);
        }
        return null;
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull ColorData data) {
        if (item.getMeta() instanceof LeatherArmorMeta) {
            ((LeatherArmorMeta)item.getMeta()).setColor(data.getColor());
        }
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull ColorData data) {
        return new ArrayList<ItemTag>();
    }
}

