/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import io.lumine.mythic.lib.gson.JsonArray;
import io.lumine.mythic.lib.gson.JsonElement;
import io.lumine.mythic.lib.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.interaction.projectile.ArrowPotionEffectArrayItem;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.PotionEffectData;
import net.Indyuce.mmoitems.stat.data.PotionEffectListData;
import net.Indyuce.mmoitems.stat.data.random.RandomPotionEffectData;
import net.Indyuce.mmoitems.stat.data.random.RandomPotionEffectListData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrowPotionEffects
extends ItemStat<RandomPotionEffectListData, PotionEffectListData> {
    public ArrowPotionEffects() {
        super("ARROW_POTION_EFFECTS", Material.TIPPED_ARROW, "Arrow Potion Effects", new String[]{"The effects to be applied when", "entities are shot by this bow"}, new String[]{"bow", "crossbow"}, new Material[0]);
    }

    @Override
    public RandomPotionEffectListData whenInitialized(Object object) {
        Validate.isTrue((boolean)(object instanceof ConfigurationSection), (String)"Must specify a config section");
        return new RandomPotionEffectListData((ConfigurationSection)object);
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.PICKUP_ALL) {
            new StatEdition(inv, ItemStats.ARROW_POTION_EFFECTS, new Object[0]).enable("Write in the chat the potion effect you want to add.", ChatColor.AQUA + "Format: [POTION_EFFECT] [DURATION] [AMPLIFIER]");
        }
        if (event.getAction() == InventoryAction.PICKUP_HALF && inv.getEditedSection().contains("arrow-potion-effects")) {
            Set set = inv.getEditedSection().getConfigurationSection("arrow-potion-effects").getKeys(false);
            String last = Arrays.asList(set.toArray(new String[0])).get(set.size() - 1);
            inv.getEditedSection().set("arrow-potion-effects." + last, null);
            if (set.size() <= 1) {
                inv.getEditedSection().set("arrow-potion-effects", null);
            }
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Successfully removed " + last.substring(0, 1).toUpperCase() + last.substring(1).toLowerCase() + ChatColor.GRAY + ".");
        }
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        String[] split = message.split(" ");
        Validate.isTrue((split.length == 3 ? 1 : 0) != 0, (String)(message + " is not a valid [POTION_EFFECT] [DURATION] [AMPLIFIER]. Example: 'FAST_DIGGING 30 3' stands for Haste 3 for 30 seconds."));
        PotionEffectType effect = null;
        for (PotionEffectType effect1 : PotionEffectType.values()) {
            if (effect1 == null || !effect1.getName().equalsIgnoreCase(split[0].replace("-", "_"))) continue;
            effect = effect1;
            break;
        }
        Validate.notNull(effect, (String)(split[0] + " is not a valid potion effect."));
        double duration = MMOUtils.parseDouble(split[1]);
        int amplifier = (int)MMOUtils.parseDouble(split[2]);
        ConfigurationSection section = inv.getEditedSection().createSection("arrow-potion-effects." + effect.getName());
        section.set("duration", (Object)duration);
        section.set("amplifier", (Object)amplifier);
        inv.getEditedSection().set("arrow-potion-effects." + effect.getName(), (Object)section);
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + effect.getName() + " " + amplifier + " successfully added.");
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<RandomPotionEffectListData> statData) {
        if (statData.isPresent()) {
            lore.add(ChatColor.GRAY + "Current Value:");
            RandomPotionEffectListData data = statData.get();
            for (RandomPotionEffectData effect : data.getEffects()) {
                lore.add(ChatColor.GRAY + "* " + ChatColor.GREEN + UtilityMethods.caseOnWords((String)effect.getType().getName().toLowerCase().replace("_", " ")) + ChatColor.GRAY + " Level: " + ChatColor.GREEN + effect.getAmplifier() + ChatColor.GRAY + " Duration: " + ChatColor.GREEN + effect.getDuration());
            }
        } else {
            lore.add(ChatColor.GRAY + "Current Value: " + ChatColor.RED + "None");
        }
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Click to add an effect.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to remove the last effect.");
    }

    @Override
    @NotNull
    public PotionEffectListData getClearStatData() {
        return new PotionEffectListData(new PotionEffectData[0]);
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull PotionEffectListData data) {
        ArrayList<String> lore = new ArrayList<String>();
        String permEffectFormat = this.getGeneralStatFormat();
        data.getEffects().forEach(effect -> lore.add(permEffectFormat.replace("{effect}", MMOItems.plugin.getLanguage().getPotionEffectName(effect.getType()) + " " + MMOUtils.intToRoman(effect.getLevel()) + "(" + MythicLib.plugin.getMMOConfig().decimal.format(effect.getDuration()) + "s)")));
        item.getLore().insert(this.getPath(), lore);
        item.addItemTag(this.getAppliedNBT(data));
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull PotionEffectListData data) {
        ArrayList<ItemTag> tags = new ArrayList<ItemTag>();
        JsonArray array = new JsonArray();
        data.getEffects().forEach(effect -> {
            JsonObject object = new JsonObject();
            object.addProperty("type", effect.getType().getName());
            object.addProperty("level", (Number)effect.getLevel());
            object.addProperty("duration", (Number)effect.getDuration());
            array.add((JsonElement)object);
        });
        tags.add(new ItemTag(this.getNBTPath(), (Object)array.toString()));
        return tags;
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        StatData data;
        ArrayList<ItemTag> relevantTags = new ArrayList<ItemTag>();
        if (mmoitem.getNBT().hasTag(this.getNBTPath())) {
            relevantTags.add(ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.STRING));
        }
        if ((data = this.getLoadedNBT((ArrayList)relevantTags)) != null) {
            mmoitem.setData(this, data);
        }
    }

    @Override
    @Nullable
    public PotionEffectListData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag tg = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (tg != null) {
            PotionEffectListData effects = new PotionEffectListData(new PotionEffectData[0]);
            for (ArrowPotionEffectArrayItem entry : (ArrowPotionEffectArrayItem[])MythicLib.plugin.getJson().parse((String)tg.getValue(), ArrowPotionEffectArrayItem[].class)) {
                effects.add(new PotionEffectData(PotionEffectType.getByName((String)entry.type), entry.duration, entry.level));
            }
            return effects;
        }
        return null;
    }
}

