/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.skill;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegisteredSkill {
    @NotNull
    private final SkillHandler<?> handler;
    @NotNull
    private final String name;
    @NotNull
    private final Map<String, String> parameterNames = new HashMap<String, String>();
    @NotNull
    private final Map<String, Double> defaultParameterValues = new HashMap<String, Double>();

    public RegisteredSkill(@NotNull SkillHandler<?> handler, @NotNull ConfigurationSection config) {
        this.handler = handler;
        this.name = Objects.requireNonNull(config.getString("name"), "Could not fill skill name");
        for (String mod : handler.getModifiers()) {
            this.parameterNames.put(mod, config.getString("modifier." + mod + ".name", UtilityMethods.caseOnWords((String)mod.replace("_", " ").replace("-", " ").toLowerCase())));
            this.defaultParameterValues.put(mod, config.getDouble("modifier." + mod + ".default-value"));
        }
    }

    @Deprecated
    public RegisteredSkill(@NotNull SkillHandler handler, @NotNull String name) {
        this.handler = handler;
        this.name = name;
    }

    @NotNull
    public SkillHandler<?> getHandler() {
        return this.handler;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Deprecated
    public void setDefaultValue(String modifier, double value) {
        this.defaultParameterValues.put(modifier, value);
    }

    @Deprecated
    public void setName(String modifier, String name) {
        this.parameterNames.put(modifier, name);
    }

    @Nullable
    public String getParameterName(String modifier) {
        return this.parameterNames.get(modifier);
    }

    public double getDefaultModifier(String modifier) {
        return this.defaultParameterValues.get(modifier);
    }
}

