/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.manager.data;

import io.lumine.mythic.lib.data.DefaultOfflineDataHolder;
import io.lumine.mythic.lib.data.yaml.YAMLSynchronizedDataHandler;
import java.util.ArrayList;
import java.util.UUID;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class YAMLDataHandler
extends YAMLSynchronizedDataHandler<PlayerData, DefaultOfflineDataHolder> {
    public YAMLDataHandler() {
        super((Plugin)MMOItems.plugin);
    }

    public void saveInSection(PlayerData playerData, ConfigurationSection config) {
        config.createSection("crafting-queue");
        config.set("permissions-from-items", new ArrayList<String>(playerData.getPermissions()));
        playerData.getCrafting().save(config.getConfigurationSection("crafting-queue"));
    }

    public void loadFromSection(PlayerData playerData, ConfigurationSection config) {
        if (config.contains("crafting-queue")) {
            playerData.getCrafting().load(playerData, config.getConfigurationSection("crafting-queue"));
        }
        if (MMOItems.plugin.hasPermissions() && config.contains("permissions-from-items")) {
            Permission perms = MMOItems.plugin.getVault().getPermissions();
            config.getStringList("permissions-from-items").forEach(perm -> {
                if (perms.has(playerData.getPlayer(), perm)) {
                    perms.playerRemove(playerData.getPlayer(), perm);
                }
            });
        }
    }

    public void setup() {
    }

    public DefaultOfflineDataHolder getOffline(@NotNull UUID uuid) {
        return new DefaultOfflineDataHolder(uuid);
    }

    public void close() {
    }
}

