/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ConfigFile;
import net.Indyuce.mmoitems.api.block.CustomBlock;
import net.Indyuce.mmoitems.api.block.WorldGenTemplate;
import net.Indyuce.mmoitems.api.world.MMOBlockPopulator;
import net.Indyuce.mmoitems.listener.WorldGenerationListener;
import net.Indyuce.mmoitems.manager.Reloadable;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class WorldGenManager
implements Reloadable {
    private final Map<String, WorldGenTemplate> templates = new HashMap<String, WorldGenTemplate>();
    private final Map<CustomBlock, WorldGenTemplate> assigned = new HashMap<CustomBlock, WorldGenTemplate>();
    private WorldGenerationListener listener;

    public WorldGenManager() {
        this.reload();
    }

    public WorldGenTemplate getOrThrow(String id) {
        Validate.isTrue((boolean)this.templates.containsKey(id), (String)("Could not find gen template with ID '" + id + "'"));
        return this.templates.get(id);
    }

    public void assign(CustomBlock block, WorldGenTemplate template) {
        Validate.notNull((Object)template, (String)"Cannot assign a null template to a custom block");
        this.assigned.put(block, template);
    }

    @Override
    public void reload() {
        if (this.listener != null) {
            HandlerList.unregisterAll((Listener)this.listener);
        }
        this.assigned.clear();
        this.templates.clear();
        FileConfiguration config = new ConfigFile("gen-templates").getConfig();
        for (String key : config.getKeys(false)) {
            try {
                WorldGenTemplate template = new WorldGenTemplate(config.getConfigurationSection(key));
                this.templates.put(template.getId(), template);
            }
            catch (IllegalArgumentException exception) {
                MMOItems.plugin.getLogger().log(Level.SEVERE, "An error occurred when loading gen template '" + key + "': " + exception.getMessage());
            }
        }
        if (MMOItems.plugin.getLanguage().worldGenEnabled) {
            this.listener = new WorldGenerationListener(this);
            Bukkit.getPluginManager().registerEvents((Listener)this.listener, (Plugin)MMOItems.plugin);
        }
    }

    public void unload() {
        if (this.listener != null) {
            HandlerList.unregisterAll((Listener)this.listener);
        }
    }

    public MMOBlockPopulator populator(@NotNull World world) {
        return new MMOBlockPopulator(world, this);
    }

    public Map<CustomBlock, WorldGenTemplate> assigned() {
        return this.assigned;
    }
}

