/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.manager;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.Indyuce.mmoitems.api.ConfigFile;
import net.Indyuce.mmoitems.api.UpgradeTemplate;
import net.Indyuce.mmoitems.manager.Reloadable;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeManager
implements Reloadable {
    private final Map<String, UpgradeTemplate> templates = new HashMap<String, UpgradeTemplate>();

    public UpgradeManager() {
        this.reload();
    }

    @Override
    public void reload() {
        this.templates.clear();
        FileConfiguration config = new ConfigFile("upgrade-templates").getConfig();
        for (String key : config.getKeys(false)) {
            this.registerTemplate(new UpgradeTemplate(config.getConfigurationSection(key)));
        }
    }

    public Collection<UpgradeTemplate> getAll() {
        return this.templates.values();
    }

    @Nullable
    public UpgradeTemplate getTemplate(@NotNull String id) {
        return this.templates.get(id);
    }

    public boolean hasTemplate(String id) {
        return this.templates.containsKey(id);
    }

    public void registerTemplate(UpgradeTemplate template) {
        this.templates.put(template.getId(), template);
    }
}

