/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.manager;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ConfigFile;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.manager.ConfigManager;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeManager {
    private final Map<String, Type> map = new LinkedHashMap<String, Type>();

    public void reload(boolean clearBefore) {
        if (clearBefore) {
            this.map.clear();
        }
        for (Field field : Type.class.getFields()) {
            try {
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !(field.get(null) instanceof Type)) continue;
                this.register((Type)field.get(null));
            }
            catch (Exception exception) {
                MMOItems.plugin.getLogger().log(Level.SEVERE, "Couldn't register type called '" + field.getName() + "': " + exception.getMessage());
            }
        }
        ConfigManager.DefaultFile.ITEM_TYPES.checkFile();
        FileConfiguration config = new ConfigFile("item-types").getConfig();
        for (String id : config.getKeys(false)) {
            if (this.map.containsKey(id)) continue;
            try {
                this.register(new Type(this, config.getConfigurationSection(id)));
            }
            catch (IllegalArgumentException exception) {
                MMOItems.plugin.getLogger().log(Level.SEVERE, "Could not register type '" + id + "': " + exception.getMessage());
            }
        }
        Iterator<Type> iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            Type type;
            block10: {
                type = iterator.next();
                try {
                    ConfigurationSection section = config.getConfigurationSection(type.getId());
                    Validate.notNull((Object)section, (String)"Could not find config section");
                    type.load(section);
                    if (!clearBefore) break block10;
                    type.getPostLoadAction().performAction();
                }
                catch (RuntimeException exception) {
                    MMOItems.plugin.getLogger().log(Level.SEVERE, "Could not register type '" + type.getId() + "': " + exception.getMessage());
                    iterator.remove();
                    continue;
                }
            }
            type.getAvailableStats().clear();
            MMOItems.plugin.getStats().getAll().stream().filter(stat -> stat.isCompatible(type)).forEach(stat -> type.getAvailableStats().add((ItemStat)stat));
        }
    }

    public void postload() {
        for (Type type : this.map.values()) {
            try {
                type.getPostLoadAction().performAction();
            }
            catch (RuntimeException exception) {
                MMOItems.plugin.getLogger().log(Level.SEVERE, "An error occured while post-loading type '" + type.getId() + "': " + exception.getMessage());
            }
        }
    }

    public void register(Type type) {
        this.map.put(type.getId(), type);
    }

    public void registerAll(Type ... types) {
        for (Type type : types) {
            this.register(type);
        }
    }

    @Nullable
    public Type get(@Nullable String id) {
        if (id == null) {
            return null;
        }
        return this.map.get(id);
    }

    @NotNull
    public Type getOrThrow(@Nullable String id) {
        Validate.isTrue((boolean)this.map.containsKey(id), (String)("Could not find item type with ID '" + id + "'"));
        return this.map.get(id);
    }

    public boolean has(String id) {
        return this.map.containsKey(id);
    }

    public Collection<Type> getAll() {
        return this.map.values();
    }

    public ArrayList<String> getAllTypeNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (Type t : this.getAll()) {
            ret.add(t.getId());
        }
        return ret;
    }
}

