/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.manager;

import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackCategory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackPalette;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ConfigFile;
import net.Indyuce.mmoitems.api.ItemTier;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.item.template.ModifierNode;
import net.Indyuce.mmoitems.api.util.TemplateMap;
import net.Indyuce.mmoitems.api.util.message.FFPMMOItems;
import net.Indyuce.mmoitems.manager.Reloadable;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateManager
implements Reloadable {
    private final TemplateMap<MMOItemTemplate> templates = new TemplateMap();
    private final Map<String, ModifierNode> modifierNodes = new HashMap<String, ModifierNode>();
    private static final Random RANDOM = new Random();

    public boolean hasTemplate(@Nullable Type type, @Nullable String id) {
        if (type == null || id == null) {
            return false;
        }
        return this.templates.hasValue(type, id);
    }

    public boolean hasTemplate(@Nullable NBTItem nbt) {
        if (nbt == null) {
            return false;
        }
        return this.hasTemplate(Type.get(nbt.getType()), nbt.getString("MMOITEMS_ITEM_ID"));
    }

    @Nullable
    public MMOItemTemplate getTemplate(@Nullable Type type, @Nullable String id) {
        if (type == null || id == null) {
            return null;
        }
        return this.templates.getValue(type, id);
    }

    @Nullable
    public MMOItemTemplate getTemplate(@Nullable NBTItem nbt) {
        if (nbt == null) {
            return null;
        }
        return this.getTemplate(Type.get(nbt.getType()), nbt.getString("MMOITEMS_ITEM_ID"));
    }

    @NotNull
    public MMOItemTemplate getTemplateOrThrow(@Nullable Type type, @Nullable String id) {
        Validate.isTrue((type != null && this.hasTemplate(type, id) ? 1 : 0) != 0, (String)("Could not find a template with ID '" + id + "'"));
        return this.templates.getValue(type, id);
    }

    @NotNull
    public Collection<MMOItemTemplate> getTemplates(@NotNull Type type) {
        return this.templates.collectValues(type);
    }

    @NotNull
    public ArrayList<String> getTemplateNames(@NotNull Type type) {
        ArrayList<String> names = new ArrayList<String>();
        for (MMOItemTemplate t : this.templates.collectValues(type)) {
            names.add(t.getId());
        }
        return names;
    }

    public void registerTemplate(@NotNull MMOItemTemplate template) {
        Validate.notNull((Object)template, (String)"MMOItem template cannot be null");
        this.templates.setValue(template.getType(), template.getId(), template);
    }

    public void unregisterTemplate(@NotNull Type type, @NotNull String id) {
        this.templates.removeValue(type, id);
    }

    public void deleteTemplate(@NotNull Type type, @NotNull String id) {
        this.unregisterTemplate(type, id);
        ConfigFile config = type.getConfigFile();
        config.getConfig().set(id, null);
        config.save();
    }

    public MMOItemTemplate requestTemplateUpdate(@NotNull Type type, @NotNull String id) {
        this.templates.removeValue(type, id);
        try {
            MMOItemTemplate template = new MMOItemTemplate(type, type.getConfigFile().getConfig().getConfigurationSection(id));
            template.getPostLoadAction().performAction();
            this.registerTemplate(template);
            return template;
        }
        catch (IllegalArgumentException exception) {
            MMOItems.plugin.getLogger().log(Level.SEVERE, "An error occurred while trying to reload item gen template '" + id + "': " + exception.getMessage());
            return null;
        }
    }

    public Collection<MMOItemTemplate> collectTemplates() {
        return this.templates.collectValues();
    }

    @Deprecated
    public boolean hasModifier(String id) {
        return this.modifierNodes.get(id) != null;
    }

    @Deprecated
    @Nullable
    public ModifierNode getModifier(String id) {
        return this.modifierNodes.get(id);
    }

    @Deprecated
    public Collection<ModifierNode> getModifiers() {
        return this.modifierNodes.values();
    }

    public boolean hasModifierNode(@NotNull String id) {
        return this.modifierNodes.containsKey(id);
    }

    @Nullable
    public ModifierNode getModifierNode(@NotNull String id) {
        return this.modifierNodes.get(id);
    }

    @NotNull
    public Collection<ModifierNode> getModifierNodes() {
        return this.modifierNodes.values();
    }

    @Nullable
    public ItemTier rollTier() {
        double s = 0.0;
        for (ItemTier tier : MMOItems.plugin.getTiers().getAll()) {
            if (s >= 1.0 || RANDOM.nextDouble() < tier.getGenerationChance() / (1.0 - s)) {
                return tier;
            }
            s += tier.getGenerationChance();
        }
        return null;
    }

    public int rollLevel(int playerLevel) {
        double spread = MMOItems.plugin.getLanguage().levelSpread;
        double found = RANDOM.nextGaussian() * spread * 0.7 + (double)playerLevel;
        found = Math.max(Math.min(found, (double)playerLevel + spread), Math.max(1.0, (double)playerLevel - spread));
        return (int)found;
    }

    @Deprecated
    public void preloadTemplates() {
        this.preloadObjects();
    }

    @Deprecated
    public void postloadTemplates() {
        this.postloadObjects();
    }

    public void preloadObjects() {
        FriendlyFeedbackProvider ffp = new FriendlyFeedbackProvider((FriendlyFeedbackPalette)FFPMMOItems.get());
        ffp.activatePrefix(true, "Template Modifiers");
        ffp.log(FriendlyFeedbackCategory.INFORMATION, "Preloading template modifiers, please wait..", new String[0]);
        for (File file : new File(MMOItems.plugin.getDataFolder() + "/modifiers").listFiles()) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            ffp.activatePrefix(true, "Modifiers \u00a78($r" + file.getPath() + "\u00a78)");
            for (String key : config.getKeys(false)) {
                try {
                    ModifierNode node = ModifierNode.fromConfig(key, config.get(key));
                    this.modifierNodes.put(node.getId(), node);
                }
                catch (RuntimeException exception) {
                    ffp.log(FriendlyFeedbackCategory.INFORMATION, "Could not load '{0}': {1}", new String[]{key, exception.getMessage()});
                }
            }
        }
        ffp.activatePrefix(true, "Item Templates");
        ffp.log(FriendlyFeedbackCategory.INFORMATION, "Preloading item templates, please wait..", new String[0]);
        for (Type type : MMOItems.plugin.getTypes().getAll()) {
            FileConfiguration config = type.getConfigFile().getConfig();
            for (String key : config.getKeys(false)) {
                try {
                    this.registerTemplate(new MMOItemTemplate(type, config.getConfigurationSection(key)));
                }
                catch (IllegalArgumentException exception) {
                    ffp.log(FriendlyFeedbackCategory.ERROR, "Could not preload item template '{0}': {1}", new String[]{key, exception.getMessage()});
                }
            }
        }
        ffp.sendAllTo(MMOItems.getConsole());
    }

    public void postloadObjects() {
        FriendlyFeedbackProvider ffp = new FriendlyFeedbackProvider((FriendlyFeedbackPalette)FFPMMOItems.get());
        ffp.activatePrefix(true, "Template Modifiers");
        ffp.log(FriendlyFeedbackCategory.INFORMATION, "Loading template modifiers, please wait..", new String[0]);
        for (ModifierNode node : this.modifierNodes.values()) {
            try {
                node.getPostLoadAction().performAction();
            }
            catch (Exception exception) {
                ffp.log(FriendlyFeedbackCategory.INFORMATION, "Could not post-load template modifier '{0}': {1}", new String[]{node.getId(), exception.getMessage()});
            }
        }
        ffp.activatePrefix(true, "Item Templates");
        ffp.log(FriendlyFeedbackCategory.INFORMATION, "Loading item templates, please wait...", new String[0]);
        this.templates.forEach(template -> {
            try {
                template.getPostLoadAction().performAction();
            }
            catch (Exception exception) {
                ffp.activatePrefix(true, "Item Templates \u00a78($r" + template.getType().getId() + "\u00a78)");
                ffp.log(FriendlyFeedbackCategory.INFORMATION, "Could not post-load item template '" + template.getId() + "': " + exception.getMessage(), new String[0]);
            }
        });
        ffp.sendAllTo(MMOItems.getConsole());
    }

    @Override
    public void reload() {
        this.templates.clear();
        this.modifierNodes.clear();
        this.preloadObjects();
        this.postloadObjects();
    }
}

