/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.manager;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ConfigFile;
import net.Indyuce.mmoitems.api.ItemSet;
import net.Indyuce.mmoitems.manager.Reloadable;
import org.bukkit.configuration.ConfigurationSection;

public class SetManager
implements Reloadable {
    private final Map<String, ItemSet> itemSets = new HashMap<String, ItemSet>();

    public SetManager() {
        this.reload();
    }

    @Override
    public void reload() {
        this.itemSets.clear();
        ConfigFile config = new ConfigFile("item-sets");
        for (String id : config.getConfig().getKeys(false)) {
            try {
                ConfigurationSection section = config.getConfig().getConfigurationSection(id);
                if (section == null) {
                    throw new IllegalStateException(String.format("Item set '%s' is not a valid configuration section.", id));
                }
                this.itemSets.put(id, new ItemSet(section));
            }
            catch (IllegalArgumentException exception) {
                MMOItems.plugin.getLogger().log(Level.SEVERE, String.format("Could not load item set '%s': %s", id, exception.getMessage()));
            }
        }
    }

    public void register(ItemSet set) {
        this.itemSets.put(set.getId(), set);
    }

    public boolean has(String id) {
        return this.itemSets.containsKey(id);
    }

    public Collection<ItemSet> getAll() {
        return this.itemSets.values();
    }

    public ItemSet get(String id) {
        return this.itemSets.getOrDefault(id, null);
    }
}

