/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.manager;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ConfigFile;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.manager.Reloadable;
import net.Indyuce.mmoitems.tooltip.TooltipTexture;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoreFormatManager
implements Reloadable {
    private final Map<String, List<String>> formats = new HashMap<String, List<String>>();
    private final Map<String, TooltipTexture> tooltips = new HashMap<String, TooltipTexture>();

    @Override
    public void reload() {
        this.formats.clear();
        this.tooltips.clear();
        File dir = new File(MMOItems.plugin.getDataFolder() + "/language/lore-formats");
        for (File file : dir.listFiles()) {
            try {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                Validate.isTrue((boolean)config.isList("lore-format"), (String)("Invalid lore-format! (" + file.getName() + ")"));
                this.formats.put(file.getName().substring(0, file.getName().length() - 4), config.getStringList("lore-format"));
            }
            catch (IllegalArgumentException exception) {
                MMOItems.plugin.getLogger().log(Level.SEVERE, "Could not load layout '" + file.getName() + "': " + exception.getMessage());
            }
        }
        FileConfiguration tooltipsConfig = new ConfigFile("tooltips").getConfig();
        for (String key : tooltipsConfig.getKeys(false)) {
            try {
                TooltipTexture tooltip = new TooltipTexture(tooltipsConfig.getConfigurationSection(key));
                this.tooltips.put(tooltip.getId(), tooltip);
            }
            catch (Exception exception) {
                MMOItems.plugin.getLogger().log(Level.SEVERE, "Could not load tooltip '" + key + "': " + exception.getMessage());
            }
        }
    }

    public boolean hasFormat(@NotNull String id) {
        return this.formats.containsKey(id);
    }

    @NotNull
    public Collection<List<String>> getFormats() {
        return this.formats.values();
    }

    public boolean hasTooltip(@NotNull String id) {
        return this.tooltips.containsKey(id);
    }

    @NotNull
    public Collection<TooltipTexture> getTooltips() {
        return this.tooltips.values();
    }

    @Nullable
    public TooltipTexture getTooltip(@NotNull String id) {
        return this.tooltips.get(id);
    }

    @NotNull
    public List<String> getFormat(@NotNull MMOItem mmoitem) {
        List<String> format;
        if (mmoitem.hasData(ItemStats.LORE_FORMAT) && (format = this.formats.get(mmoitem.getData(ItemStats.LORE_FORMAT).toString())) != null) {
            return format;
        }
        if (mmoitem.getType().getLoreFormat() != null && (format = this.formats.get(mmoitem.getType().getLoreFormat())) != null) {
            return format;
        }
        return MMOItems.plugin.getLanguage().getDefaultLoreFormat();
    }

    @Deprecated
    @NotNull
    public List<String> getFormat(String ... prioritizedFormatNames) {
        for (String format : prioritizedFormatNames) {
            List<String> found = this.formats.get(format);
            if (found == null) continue;
            return found;
        }
        return MMOItems.plugin.getLanguage().getDefaultLoreFormat();
    }
}

